"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabColor = tabColor;
var _mlStringHash = require("@kbn/ml-string-hash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const colorMap = Object.create(null);
function tabColor(name, euiTheme) {
  const COLORS = [
  // Amsterdam + Borealis
  euiTheme.colors.vis.euiColorVis0, euiTheme.colors.vis.euiColorVis1, euiTheme.colors.vis.euiColorVis2, euiTheme.colors.vis.euiColorVis3, euiTheme.colors.vis.euiColorVis4, euiTheme.colors.vis.euiColorVis5, euiTheme.colors.vis.euiColorVis6, euiTheme.colors.vis.euiColorVis7, euiTheme.colors.vis.euiColorVis8, euiTheme.colors.vis.euiColorVis9, euiTheme.colors.darkShade, euiTheme.colors.primary];
  if (colorMap[name] === undefined) {
    const n = (0, _mlStringHash.stringHash)(name);
    const color = COLORS[n % COLORS.length];
    colorMap[name] = color;
    return color;
  } else {
    return colorMap[name];
  }
}