"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.searchOptionsSchema = exports.mapsUpdateOptionsSchema = exports.mapsSearchOptionsSchema = exports.mapsGetResultSchema = exports.mapsCreateResultSchema = exports.mapsCreateOptionsSchema = exports.mapSavedObjectSchema = exports.mapAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapAttributesSchema = exports.mapAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  mapStateJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  layerListJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  uiStateJSON: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'forbid'
});
const mapSavedObjectSchema = exports.mapSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(mapAttributesSchema);
const searchOptionsSchema = exports.searchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const mapsSearchOptionsSchema = exports.mapsSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const mapsCreateOptionsSchema = exports.mapsCreateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.referencesSchema)
}));
const mapsUpdateOptionsSchema = exports.mapsUpdateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.referencesSchema)
}));
const mapsGetResultSchema = exports.mapsGetResultSchema = (0, _contentManagementUtils.objectTypeToGetResultSchema)(mapSavedObjectSchema);
const mapsCreateResultSchema = exports.mapsCreateResultSchema = (0, _contentManagementUtils.createResultSchema)(mapSavedObjectSchema);

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(mapSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: mapsCreateOptionsSchema
      },
      data: {
        schema: mapAttributesSchema
      }
    },
    out: {
      result: {
        schema: mapsCreateResultSchema
      }
    }
  },
  update: {
    in: {
      options: {
        schema: mapsUpdateOptionsSchema
      },
      data: {
        schema: mapAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: searchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: mapSavedObjectSchema
      }
    }
  }
};