"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Category = Category;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _constants = require("../../../../../../common/constants");
var _vector_icon = require("./vector_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/category.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Category({
  styleName,
  label,
  color,
  isLinesOnly,
  isPointsOnly,
  symbolId,
  svg
}) {
  const styles = (0, _use_memo_css.useMemoCss)(categoryStyles);
  function renderIcon() {
    if (styleName === _constants.VECTOR_STYLES.LABEL_COLOR) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        style: {
          color
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      }, "Tx");
    }
    return /*#__PURE__*/_react.default.createElement(_vector_icon.VectorIcon, {
      fillColor: styleName === _constants.VECTOR_STYLES.FILL_COLOR ? color : 'none',
      isPointsOnly: isPointsOnly,
      isLinesOnly: isLinesOnly,
      strokeColor: color,
      symbolId: symbolId,
      svg: svg,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.itemMargin,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, renderIcon()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, label)));
}
const categoryStyles = {
  itemMargin: ({
    euiTheme
  }) => (0, _react2.css)({
    width: euiTheme.size.l
  })
};