"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalLinkComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _content_management = require("../../../common/content_management");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/external_link/external_link_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExternalLinkComponent = ({
  link,
  layout
}) => {
  var _link$error;
  const linkOptions = (0, _react.useMemo)(() => {
    return {
      ..._public.DEFAULT_URL_DRILLDOWN_OPTIONS,
      ...link.options
    };
  }, [link.options]);
  const destination = (0, _react.useMemo)(() => {
    return link.destination && linkOptions.encodeUrl ? encodeURI(link.destination) : link.destination;
  }, [linkOptions, link.destination]);
  const id = `externalLink--${link.id}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    size: "s",
    external: true,
    color: "text",
    isDisabled: Boolean(link.error),
    className: 'linksPanelLink',
    showToolTip: Boolean(link.error),
    toolTipProps: {
      content: (_link$error = link.error) === null || _link$error === void 0 ? void 0 : _link$error.message,
      position: layout === _content_management.LINKS_VERTICAL_LAYOUT ? 'right' : 'bottom',
      repositionOnScroll: true,
      delay: 'long',
      'data-test-subj': `${id}--tooltip`
    },
    iconType: link.error ? 'warning' : undefined,
    id: id,
    label: link.label || link.destination,
    "data-test-subj": link.error ? `${id}--error` : `${id}`,
    href: destination,
    onClick: async event => {
      if (!destination) return;
      _kibana_services.trackUiMetric === null || _kibana_services.trackUiMetric === void 0 ? void 0 : (0, _kibana_services.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, `${_content_management.EXTERNAL_LINK_TYPE}:click`);

      /** Only use `navigateToUrl` if we **aren't** opening in a new window/tab; otherwise, just use default href handling */
      const modifiedClick = event.ctrlKey || event.metaKey || event.shiftKey;
      if (!modifiedClick) {
        event.preventDefault();
        if (linkOptions.openInNewTab) {
          window.open(destination, '_blank');
        } else {
          await _kibana_services.coreServices.application.navigateToUrl(destination);
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
exports.ExternalLinkComponent = ExternalLinkComponent;