"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isParentApiCompatible = exports.addLinksPanelAction = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationUtil = require("@kbn/presentation-util");
var _common = require("../../common");
var _constants = require("./constants");
var _kibana_services = require("../services/kibana_services");
var _get_editor_flyout = require("../editor/get_editor_flyout");
var _resolve_links = require("../lib/resolve_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isParentApiCompatible = parentApi => (0, _presentationContainers.apiIsPresentationContainer)(parentApi) && (0, _presentationPublishing.apiPublishesSavedObjectId)(parentApi) && (0, _presentationPublishing.apiPublishesTitle)(parentApi) && (0, _presentationPublishing.apiPublishesDescription)(parentApi);
exports.isParentApiCompatible = isParentApiCompatible;
const addLinksPanelAction = exports.addLinksPanelAction = {
  id: _constants.ADD_LINKS_PANEL_ACTION_ID,
  getIconType: () => _common.APP_ICON,
  order: 10,
  isCompatible: async ({
    embeddable
  }) => isParentApiCompatible(embeddable),
  execute: async ({
    embeddable
  }) => {
    if (!isParentApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    (0, _presentationUtil.openLazyFlyout)({
      core: _kibana_services.coreServices,
      parentApi: embeddable,
      loadContent: async ({
        closeFlyout
      }) => {
        return await (0, _get_editor_flyout.getEditorFlyout)({
          parentDashboard: embeddable,
          closeFlyout,
          onCompleteEdit: async newState => {
            if (!newState) return;
            const {
              layout,
              links,
              savedObjectId
            } = newState;
            function serializeState() {
              if (savedObjectId !== undefined) {
                return {
                  rawState: {
                    savedObjectId
                  }
                };
              }
              return {
                rawState: {
                  layout,
                  links: (0, _resolve_links.serializeResolvedLinks)(links !== null && links !== void 0 ? links : [])
                }
              };
            }
            await embeddable.addNewPanel({
              panelType: _common.LINKS_EMBEDDABLE_TYPE,
              serializedState: serializeState()
            });
          }
        });
      },
      flyoutProps: {
        'data-test-subj': 'links--panelEditor--flyout'
      }
    });
  },
  grouping: [_public2.ADD_PANEL_ANNOTATION_GROUP],
  getDisplayName: () => _common.APP_NAME
};