"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensSavedObjectSchema = exports.lensResponseItemSchema = exports.lensItemSchema = exports.lensItemMetaSchema = exports.lensItemAttributesSchema = exports.lensCommonSavedObjectSchema = exports.lensAPIStateSchema = exports.lensAPIConfigSchema = exports.lensAPIAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _utils = require("../../../utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensItemAttributesSchema = exports.lensItemAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  visualizationType: _configSchema.schema.string(),
  state: _configSchema.schema.maybe(_configSchema.schema.any()),
  // TODO make version required
  version: _configSchema.schema.maybe(_configSchema.schema.literal(_constants.LENS_ITEM_VERSION)) // pin version explicitly
}, {
  unknowns: 'forbid'
});
const lensAPIStateSchema = exports.lensAPIStateSchema = _configSchema.schema.object({
  isNewApiFormat: _configSchema.schema.literal(true) // pin this to validate CB transformations
}, {
  unknowns: 'allow'
});
const lensAPIAttributesSchema = exports.lensAPIAttributesSchema = _configSchema.schema.object({
  ...lensItemAttributesSchema.getPropSchemas(),
  state: lensAPIStateSchema
}, {
  unknowns: 'forbid'
});

/**
 * The underlying SO type used to store Lens state in Content Management.
 *
 * Only used in lens server-side Content Management.
 */
const lensSavedObjectSchema = exports.lensSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(lensItemAttributesSchema);

/**
 * The common SO type used for mSearch items.
 */
const lensCommonSavedObjectSchema = exports.lensCommonSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(_configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(lensItemAttributesSchema.getPropSchemas(), ['title', 'description'])
}, {
  unknowns: 'forbid'
}));

/**
 * The Lens item data returned from the server
 */
const lensItemSchema = exports.lensItemSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(lensSavedObjectSchema.getPropSchemas(), ['id', 'references']),
  // Spread attributes at root
  ...lensSavedObjectSchema.getPropSchemas().attributes.getPropSchemas()
}, {
  unknowns: 'forbid'
});

/**
 * The Lens item data returned from the server
 */
const lensAPIConfigSchema = exports.lensAPIConfigSchema = _configSchema.schema.object({
  // TODO flatten this with new CB shape
  ...(0, _utils.pickFromObjectSchema)(lensSavedObjectSchema.getPropSchemas(), ['id', 'references']),
  // Spread attributes at root
  ...lensAPIAttributesSchema.getPropSchemas()
}, {
  unknowns: 'forbid'
});

/**
 * The Lens item meta returned from the server
 */
const lensItemMetaSchema = exports.lensItemMetaSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(lensSavedObjectSchema.getPropSchemas(), ['type', 'createdAt', 'updatedAt', 'createdBy', 'updatedBy', 'originId',
  // maybe??
  'managed'])
}, {
  unknowns: 'forbid'
});

/**
 * The Lens response item returned from the server
 */
const lensResponseItemSchema = exports.lensResponseItemSchema = _configSchema.schema.object({
  data: lensAPIConfigSchema,
  meta: lensItemMetaSchema
}, {
  unknowns: 'forbid'
});