"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoredGlobalFiltersEntries = IgnoredGlobalFiltersEntries;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _info_badge = require("../info_badges/info_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/ignore_global_filter/info_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function IgnoredGlobalFiltersEntries({
  layers,
  visualizationInfo,
  dataViews
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, layers.map((layer, layerIndex) => {
    const dataView = dataViews.indexPatterns[layer.indexPatternId];
    const layerInfo = visualizationInfo.layers.find(({
      layerId
    }) => layerId === layer.layerId);
    const layerTitle = (layerInfo === null || layerInfo === void 0 ? void 0 : layerInfo.label) || _i18n.i18n.translate('xpack.lens.layerTitle.fallbackLabel', {
      defaultMessage: 'Layer'
    });
    const layerPalette = layerInfo === null || layerInfo === void 0 ? void 0 : layerInfo.palette;
    return /*#__PURE__*/_react.default.createElement(_info_badge.InfoBadge, {
      title: layerTitle,
      index: layerIndex,
      dataView: dataView.id,
      palette: layerPalette,
      "data-test-subj-prefix": "lns-feature-badges-ignoreGlobalFilters",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    });
  }));
}