"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.percentileOperation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/expressions-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _esqlUtils = require("@kbn/esql-utils");
var _lodash = require("lodash");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _shared_components = require("./shared_components");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _get_group_by_key = require("./get_group_by_key");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/percentile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PERCENTILE_VALUE = 95;
const ALLOWED_DECIMAL_DIGITS = 4;
function ofName(name, percentile, timeShift, reducedTimeRange) {
  const formatters = {
    getNumberFormat: (0, _lodash.memoize)((locale, opts) => new Intl.NumberFormat(locale, {
      ...opts,
      // To resolve a type mismatch in the 'useGrouping' property
      maximumFractionDigits: ALLOWED_DECIMAL_DIGITS
    })),
    // @ts-expect-error - There’s a small mismatch between @formatjs type and Intl API that only applies to the date function, we’re ignoring that
    getDateTimeFormat: (0, _lodash.memoize)((locale, opts) => new Intl.DateTimeFormat(locale, opts)),
    getPluralRules: (0, _lodash.memoize)((locale, opts) => new Intl.PluralRules(locale, {
      ...opts,
      maximumFractionDigits: ALLOWED_DECIMAL_DIGITS // ensures the correct ordinal suffix is selected based on the matching number of decimal digits used in the number formatter
    }))
  };
  return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(_i18n.i18n.translate('xpack.lens.indexPattern.percentileOf', {
    defaultMessage: '{percentile, selectordinal, one {#st} two {#nd} few {#rd} other {#th}} percentile of {name}',
    values: {
      name,
      percentile
    },
    formatters
  }), undefined, undefined, undefined, timeShift, undefined, reducedTimeRange);
}
function getInvalidErrorMessage(value, isInline, max, min) {
  if (!isInline && (0, _helpers.isValidNumber)(value, false, max, min, 15 // max supported digits in JS
  )) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.percentile.errorMessageTooManyDigits', {
      defaultMessage: 'Only {digits} numbers allowed after the decimal point.',
      values: {
        digits: ALLOWED_DECIMAL_DIGITS
      }
    });
  }
  return _i18n.i18n.translate('xpack.lens.indexPattern.percentile.errorMessage', {
    defaultMessage: 'Percentile has to be an integer between {min} and {max}',
    values: {
      min,
      max
    }
  });
}
const supportedFieldTypes = ['number', 'histogram'];
const percentileOperation = exports.percentileOperation = {
  type: _lensFormulaDocs.PERCENTILE_ID,
  allowAsReference: true,
  displayName: _lensFormulaDocs.PERCENTILE_NAME,
  input: 'field',
  operationParams: [{
    name: 'percentile',
    type: 'number',
    required: false,
    defaultValue: DEFAULT_PERCENTILE_VALUE
  }],
  filterable: true,
  shiftable: true,
  canReduceTimeRange: true,
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type: fieldType,
    timeSeriesMetric
  }) => {
    if (supportedFieldTypes.includes(fieldType) && aggregatable && timeSeriesMetric !== 'counter' && (!aggregationRestrictions || aggregationRestrictions.percentiles)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    return Boolean(newField && supportedFieldTypes.includes(newField.type) && newField.aggregatable && (!newField.aggregationRestrictions || !newField.aggregationRestrictions.percentiles));
  },
  getDefaultLabel: (column, columns, indexPattern) => ofName((0, _helpers.getSafeName)(column.sourceField, indexPattern), column.params.percentile, column.timeShift, column.reducedTimeRange),
  buildColumn: ({
    field,
    previousColumn,
    indexPattern
  }, columnParams) => {
    var _columnParams$percent;
    const existingPercentileParam = previousColumn && (0, _helpers.isColumnOfType)(_lensFormulaDocs.PERCENTILE_ID, previousColumn) && previousColumn.params.percentile;
    const newPercentileParam = (_columnParams$percent = columnParams === null || columnParams === void 0 ? void 0 : columnParams.percentile) !== null && _columnParams$percent !== void 0 ? _columnParams$percent : existingPercentileParam || DEFAULT_PERCENTILE_VALUE;
    return {
      label: ofName((0, _helpers.getSafeName)(field.name, indexPattern), newPercentileParam, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      dataType: 'number',
      operationType: _lensFormulaDocs.PERCENTILE_ID,
      sourceField: field.name,
      isBucketed: false,
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      params: {
        percentile: newPercentileParam,
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn)
      }
    };
  },
  onFieldChange: (oldColumn, field) => {
    return {
      ...oldColumn,
      label: ofName(field.displayName, oldColumn.params.percentile, oldColumn.timeShift, oldColumn.reducedTimeRange),
      sourceField: field.name
    };
  },
  toESQL: (column, columnId) => {
    if (column.timeShift) return;
    return `PERCENTILE(${(0, _esqlUtils.sanitazeESQLInput)(column.sourceField)}, ${column.params.percentile})`;
  },
  toEsAggsFn: (column, columnId, _indexPattern) => {
    return (0, _public.buildExpressionFunction)('aggSinglePercentile', {
      id: columnId,
      enabled: true,
      schema: 'metric',
      field: column.sourceField,
      percentile: column.params.percentile,
      // time shift is added to wrapping aggFilteredMetric if filter is set
      timeShift: column.filter ? undefined : column.timeShift
    }).toAst();
  },
  getGroupByKey: agg => (0, _get_group_by_key.getGroupByKey)(agg, ['aggSinglePercentile'], [{
    name: 'field'
  }, {
    name: 'percentile'
  }]),
  optimizeEsAggs: (_aggs, _esAggsIdMap, aggExpressionToEsAggsIdMap) => {
    let aggs = [..._aggs];
    const esAggsIdMap = {
      ..._esAggsIdMap
    };
    const percentileExpressionsByArgs = (0, _get_group_by_key.groupByKey)(aggs, expressionBuilder => (0, _get_group_by_key.getGroupByKey)(expressionBuilder, ['aggSinglePercentile'],
    // we don't group based on percentile value (just field) since we will put
    // all the percentile values in the final multi-percentile agg
    [{
      name: 'field'
    }]));
    const termsFuncs = aggs.map(agg => agg.functions[0]).filter(func => func.name === 'aggTerms');

    // collapse each group of matching aggs into a single agg expression
    Object.values(percentileExpressionsByArgs).forEach(expressionBuilders => {
      var _firstPercentileFunct, _firstPercentileFunct2, _firstPercentileFunct3, _firstPercentileFunct4;
      if (expressionBuilders.length <= 1) {
        // don't need to optimize if there aren't more than one
        return;
      }
      const {
        functions: [firstFnBuilder]
      } = expressionBuilders[0];
      const isGroupFiltered = firstFnBuilder.name === 'aggFilteredMetric';
      if (isGroupFiltered) {
        // Even though elasticsearch DSL would support this, it doesn't currently work in ESAggs to
        // put an `aggPercentiles` (multiple) as the metric (`customMetric`) arg for
        // an `aggFilteredMetric` expression function
        return;
      }

      // we're going to merge these percentile builders into a single builder, so
      // remove them from the aggs array
      aggs = aggs.filter(aggBuilder => !expressionBuilders.includes(aggBuilder));
      const {
        functions: [firstPercentileFunction]
      } = expressionBuilders[0];
      const esAggsColumnId = firstPercentileFunction.getArgument('id')[0];
      const aggPercentilesConfig = {
        id: esAggsColumnId,
        enabled: (_firstPercentileFunct = firstPercentileFunction.getArgument('enabled')) === null || _firstPercentileFunct === void 0 ? void 0 : _firstPercentileFunct[0],
        schema: (_firstPercentileFunct2 = firstPercentileFunction.getArgument('schema')) === null || _firstPercentileFunct2 === void 0 ? void 0 : _firstPercentileFunct2[0],
        field: (_firstPercentileFunct3 = firstPercentileFunction.getArgument('field')) === null || _firstPercentileFunct3 === void 0 ? void 0 : _firstPercentileFunct3[0],
        percents: [],
        // time shift is added to wrapping aggFilteredMetric if filter is set
        timeShift: (_firstPercentileFunct4 = firstPercentileFunction.getArgument('timeShift')) === null || _firstPercentileFunct4 === void 0 ? void 0 : _firstPercentileFunct4[0]
      };
      for (const builder of expressionBuilders) {
        const percentile = builder.functions[0].getArgument('percentile')[0];
        aggPercentilesConfig.percents.push(percentile);

        // update any terms order-bys
        termsFuncs.forEach(func => {
          var _func$getArgument, _builder$functions$0$;
          if (((_func$getArgument = func.getArgument('orderBy')) === null || _func$getArgument === void 0 ? void 0 : _func$getArgument[0]) === ((_builder$functions$0$ = builder.functions[0].getArgument('id')) === null || _builder$functions$0$ === void 0 ? void 0 : _builder$functions$0$[0])) {
            func.replaceArgument('orderBy', [`${esAggsColumnId}.${percentile}`]);
          }
        });
      }
      const multiPercentilesAst = (0, _public.buildExpressionFunction)('aggPercentiles', aggPercentilesConfig).toAst();
      aggs.push((0, _public.buildExpression)({
        type: 'expression',
        chain: [multiPercentilesAst]
      }));
      expressionBuilders.forEach(expressionBuilder => {
        const currentEsAggsId = aggExpressionToEsAggsIdMap.get(expressionBuilder);
        if (currentEsAggsId === undefined) {
          throw new Error('Could not find current column ID for percentile agg expression builder');
        }
        // esAggs appends the percent number to the agg id to make distinct column IDs in the resulting datatable.
        // We're anticipating that here by adding the `.<percentile>`.
        // The agg index will be assigned when we update all the indices in the ID map based on the agg order in the
        // datasource's toExpression fn so we mark it as '?' for now.
        const newEsAggsId = `col-?-${esAggsColumnId}.${expressionBuilder.functions[0].getArgument('percentile')[0]}`;
        esAggsIdMap[newEsAggsId] = esAggsIdMap[currentEsAggsId];
        delete esAggsIdMap[currentEsAggsId];
      });
    });
    return {
      esAggsIdMap,
      aggs
    };
  },
  getErrorMessage: (layer, columnId, indexPattern) => [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...(0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)],
  paramEditor: function PercentileParamEditor({
    paramEditorUpdater,
    currentColumn,
    indexPattern,
    paramEditorCustomProps
  }) {
    const {
      labels,
      isInline
    } = paramEditorCustomProps || {};
    const percentileLabel = (labels === null || labels === void 0 ? void 0 : labels[0]) || _i18n.i18n.translate('xpack.lens.indexPattern.percentile.percentileValue', {
      defaultMessage: 'Percentile'
    });
    const step = isInline ? 1 : 0.0001;
    const upperBound = isInline ? 99 : 99.9999;
    const onChange = (0, _react.useCallback)(value => {
      var _indexPattern$getFiel;
      if (!(0, _helpers.isValidNumber)(value, isInline, upperBound, step, ALLOWED_DECIMAL_DIGITS) || Number(value) === currentColumn.params.percentile) {
        return;
      }
      paramEditorUpdater({
        ...currentColumn,
        label: currentColumn.customLabel ? currentColumn.label : ofName(((_indexPattern$getFiel = indexPattern.getFieldByName(currentColumn.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.displayName) || currentColumn.sourceField, Number(value), currentColumn.timeShift, currentColumn.reducedTimeRange),
        params: {
          ...currentColumn.params,
          percentile: Number(value)
        }
      });
    }, [isInline, upperBound, step, currentColumn, paramEditorUpdater, indexPattern]);
    const {
      inputValue,
      handleInputChange: handleInputChangeWithoutValidation
    } = (0, _visualizationUtils.useDebouncedValue)({
      onChange,
      value: String(currentColumn.params.percentile)
    });
    const inputValueIsValid = (0, _helpers.isValidNumber)(inputValue, isInline, upperBound, step, ALLOWED_DECIMAL_DIGITS);
    const handleInputChange = (0, _react.useCallback)(e => handleInputChangeWithoutValidation(String(e.currentTarget.value)), [handleInputChangeWithoutValidation]);
    const handleRangeChange = (0, _react.useCallback)(e => handleInputChangeWithoutValidation(String(e.currentTarget.value)), [handleInputChangeWithoutValidation]);
    return /*#__PURE__*/_react.default.createElement(_shared_components.FormRow, {
      isInline: isInline,
      label: percentileLabel,
      "data-test-subj": "lns-indexPattern-percentile-form",
      display: "rowCompressed",
      fullWidth: true,
      isInvalid: !inputValueIsValid,
      error: !inputValueIsValid && getInvalidErrorMessage(inputValue, isInline, upperBound, step),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 7
      }
    }, isInline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      fullWidth: true,
      "data-test-subj": "lns-indexPattern-percentile-input",
      compressed: true,
      value: inputValue !== null && inputValue !== void 0 ? inputValue : '',
      min: step,
      max: upperBound,
      step: step,
      onChange: handleInputChange,
      "aria-label": percentileLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
      fullWidth: true,
      "data-test-subj": "lns-indexPattern-percentile-input",
      compressed: true,
      value: inputValue !== null && inputValue !== void 0 ? inputValue : '',
      min: step,
      max: upperBound,
      step: step,
      onChange: handleRangeChange,
      showInput: true,
      "aria-label": percentileLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 442,
        columnNumber: 11
      }
    }));
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.percentile.documentation.quick', {
    defaultMessage: `
      The largest value that is smaller than n percent of the values that occur in all documents.
      `
  })
};