"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEditConfigurationFlyout = LensEditConfigurationFlyout;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _expression_helpers = require("../../../editor_frame_service/editor_frame/expression_helpers");
var _state_management = require("../../../state_management");
var _utils = require("../../../utils");
var _layer_configuration_section = require("./layer_configuration_section");
var _flyout_wrapper = require("./flyout_wrapper");
var _suggestion_panel = require("../../../editor_frame_service/editor_frame/suggestion_panel");
var _get_application_user_messages = require("../../get_application_user_messages");
var _lens_ui_telemetry = require("../../../lens_ui_telemetry");
var _use_current_attributes = require("./use_current_attributes");
var _chart_type_session_storage = require("../../../chart_type_session_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/shared/edit_on_the_fly/lens_configuration_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LensEditConfigurationFlyout({
  attributes,
  coreStart,
  startDependencies,
  visualizationMap,
  datasourceMap,
  datasourceId,
  updatePanelState,
  updateSuggestion,
  setCurrentAttributes,
  closeFlyout,
  saveByRef,
  savedObjectId,
  updateByRefInput,
  dataLoading$,
  lensAdapters,
  navigateToLensEditor,
  displayFlyoutHeader,
  canEditTextBasedQuery,
  isNewPanel,
  hidesSuggestions,
  onApply: onApplyCallback,
  onCancel: onCancelCallback,
  isReadOnly,
  parentApi,
  panelId,
  applyButtonLabel
}) {
  var _visualization$active;
  const euiTheme = (0, _eui.useEuiTheme)();
  const previousAttributes = (0, _react.useRef)(attributes);
  const [isInlineFlyoutVisible, setIsInlineFlyoutVisible] = (0, _react.useState)(true);
  const [isLayerAccordionOpen, setIsLayerAccordionOpen] = (0, _react.useState)(true);
  const [isSuggestionsAccordionOpen, setIsSuggestionsAccordionOpen] = (0, _react.useState)(false);
  const [isESQLResultsAccordionOpen, setIsESQLResultsAccordionOpen] = (0, _react.useState)(false);
  const {
    datasourceStates,
    visualization,
    isLoading,
    annotationGroups,
    searchSessionId
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const activeVisualization = visualizationMap[(_visualization$active = visualization.activeId) !== null && _visualization$active !== void 0 ? _visualization$active : attributes.visualizationType];
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));
  framePublicAPI.absDateRange = (0, _utils.getAbsoluteDateRange)(startDependencies.data.query.timefilter.timefilter);
  const dispatch = (0, _state_management.useLensDispatch)();
  const attributesChanged = (0, _react.useMemo)(() => {
    var _visualizationMap$pre;
    if (isNewPanel) return true;
    const previousAttrs = previousAttributes.current;
    const datasourceStatesAreSame = datasourceStates[datasourceId].state && previousAttrs.state.datasourceStates[datasourceId] ? datasourceMap[datasourceId].isEqual(previousAttrs.state.datasourceStates[datasourceId], previousAttrs.references, datasourceStates[datasourceId].state, attributes.references) : false;
    if (!datasourceStatesAreSame) return true;
    const visualizationState = visualization.state;
    const customIsEqual = (_visualizationMap$pre = visualizationMap[previousAttrs.visualizationType]) === null || _visualizationMap$pre === void 0 ? void 0 : _visualizationMap$pre.isEqual;
    const visualizationStateIsEqual = customIsEqual ? (() => {
      try {
        return customIsEqual(previousAttrs.state.visualization, previousAttrs.references, visualizationState, attributes.references, annotationGroups);
      } catch (err) {
        return false;
      }
    })() : (0, _lodash.isEqual)(visualizationState, previousAttrs.state.visualization);
    return !visualizationStateIsEqual;
  }, [datasourceStates, datasourceId, datasourceMap, attributes.references, visualization.state, isNewPanel, visualizationMap, annotationGroups]);
  const onCancel = (0, _react.useCallback)(() => {
    const previousAttrs = previousAttributes.current;
    if (attributesChanged) {
      if (previousAttrs.visualizationType === visualization.activeId) {
        var _datasourceMap$dataso, _datasourceMap$dataso2;
        const currentDatasourceState = datasourceMap[datasourceId].injectReferencesToLayers ? (_datasourceMap$dataso = datasourceMap[datasourceId]) === null || _datasourceMap$dataso === void 0 ? void 0 : (_datasourceMap$dataso2 = _datasourceMap$dataso.injectReferencesToLayers) === null || _datasourceMap$dataso2 === void 0 ? void 0 : _datasourceMap$dataso2.call(_datasourceMap$dataso, previousAttrs.state.datasourceStates[datasourceId], previousAttrs.references) : previousAttrs.state.datasourceStates[datasourceId];
        updatePanelState === null || updatePanelState === void 0 ? void 0 : updatePanelState(currentDatasourceState, previousAttrs.state.visualization);
      } else {
        updateSuggestion === null || updateSuggestion === void 0 ? void 0 : updateSuggestion(previousAttrs);
      }
      if (savedObjectId) {
        updateByRefInput === null || updateByRefInput === void 0 ? void 0 : updateByRefInput(savedObjectId);
      }
    }
    // Remove the user's preferred chart type from localStorage
    (0, _chart_type_session_storage.deleteUserChartTypeFromSessionStorage)();
    onCancelCallback === null || onCancelCallback === void 0 ? void 0 : onCancelCallback();
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
  }, [attributesChanged, closeFlyout, visualization.activeId, savedObjectId, datasourceMap, datasourceId, updatePanelState, updateSuggestion, updateByRefInput, onCancelCallback]);
  const textBasedMode = (0, _esQuery.isOfAggregateQueryType)(attributes.state.query);
  const currentAttributes = (0, _use_current_attributes.useCurrentAttributes)({
    textBasedMode,
    initialAttributes: attributes,
    datasourceMap,
    visualizationMap
  });
  const onApply = (0, _react.useCallback)(() => {
    var _activeVisualization$;
    if (visualization.activeId == null || !currentAttributes) {
      return;
    }
    if (savedObjectId) {
      saveByRef === null || saveByRef === void 0 ? void 0 : saveByRef(currentAttributes);
      updateByRefInput === null || updateByRefInput === void 0 ? void 0 : updateByRefInput(savedObjectId);
    }

    // check if visualization type changed, if it did, don't pass the previous visualization state
    const prevVisState = previousAttributes.current.visualizationType === visualization.activeId ? previousAttributes.current.state.visualization : undefined;
    const telemetryEvents = (_activeVisualization$ = activeVisualization.getTelemetryEventsOnSave) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, visualization.state, prevVisState);
    if (telemetryEvents && telemetryEvents.length) {
      (0, _lens_ui_telemetry.trackSaveUiCounterEvents)(telemetryEvents);
    }
    onApplyCallback === null || onApplyCallback === void 0 ? void 0 : onApplyCallback(currentAttributes);
    // Remove the user's preferred chart type from sessionStorage
    (0, _chart_type_session_storage.deleteUserChartTypeFromSessionStorage)();
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
  }, [visualization.activeId, savedObjectId, closeFlyout, onApplyCallback, visualization.state, activeVisualization, currentAttributes, saveByRef, updateByRefInput]);
  const {
    getUserMessages
  } = (0, _get_application_user_messages.useApplicationUserMessages)({
    coreStart,
    framePublicAPI,
    activeDatasourceId: datasourceId,
    datasourceState: datasourceStates[datasourceId],
    datasource: datasourceMap[datasourceId],
    dispatch,
    visualization: activeVisualization,
    visualizationType: visualization.activeId,
    visualizationState: visualization
  });
  const editorContainer = (0, _react.useRef)(null);
  const isSaveable = (0, _react.useMemo)(() => {
    if (!attributesChanged) {
      return false;
    }
    if (!visualization.state || !visualization.activeId) {
      return false;
    }
    const visualizationErrors = getUserMessages(['visualization'], {
      severity: 'error'
    });
    // shouldn't build expression if there is any type of error other than an expression build error
    // (in which case we try again every time because the config might have changed)
    if (visualizationErrors.every(error => error.uniqueId === _utils.EXPRESSION_BUILD_ERROR_ID)) {
      return Boolean((0, _expression_helpers.buildExpression)({
        visualization: activeVisualization,
        visualizationState: visualization.state,
        datasourceMap,
        datasourceStates,
        datasourceLayers: framePublicAPI.datasourceLayers,
        indexPatterns: framePublicAPI.dataViews.indexPatterns,
        dateRange: framePublicAPI.dateRange,
        nowInstant: startDependencies.data.nowProvider.get(),
        searchSessionId
      }));
    }
  }, [attributesChanged, activeVisualization, datasourceMap, datasourceStates, framePublicAPI.dataViews.indexPatterns, framePublicAPI.dateRange, framePublicAPI.datasourceLayers, searchSessionId, startDependencies.data.nowProvider, visualization.activeId, visualization.state, getUserMessages]);
  const onKeyDown = e => {
    if (e.key === _eui.keys.ESCAPE) {
      closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
      setIsInlineFlyoutVisible(false);
      // Remove the user's preferred chart type from sessionStorage
      (0, _chart_type_session_storage.deleteUserChartTypeFromSessionStorage)();
    }
  };
  if (isLoading) return null;
  // Example is the Discover editing where we dont want to render the text based editor on the panel, neither the suggestions (for now)
  if (!canEditTextBasedQuery && hidesSuggestions) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInlineFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
      event: "keydown",
      handler: onKeyDown,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 35
      }
    }), /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
      isInlineFlyoutVisible: isInlineFlyoutVisible,
      displayFlyoutHeader: displayFlyoutHeader,
      onCancel: onCancel,
      navigateToLensEditor: navigateToLensEditor,
      onApply: onApply,
      isScrollable: true,
      isNewPanel: isNewPanel,
      isSaveable: isSaveable,
      isReadOnly: isReadOnly,
      applyButtonLabel: applyButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_layer_configuration_section.LayerConfiguration
    // TODO: remove this once we support switching to any chart in Discover
    , {
      onlyAllowSwitchToSubtypes: true,
      getUserMessages: getUserMessages,
      attributes: attributes,
      coreStart: coreStart,
      startDependencies: startDependencies,
      visualizationMap: visualizationMap,
      datasourceMap: datasourceMap,
      datasourceId: datasourceId,
      hasPadding: true,
      framePublicAPI: framePublicAPI,
      setIsInlineFlyoutVisible: setIsInlineFlyoutVisible,
      updateSuggestion: updateSuggestion,
      setCurrentAttributes: setCurrentAttributes,
      closeFlyout: closeFlyout,
      parentApi: parentApi,
      panelId: panelId,
      canEditTextBasedQuery: canEditTextBasedQuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInlineFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
    isInlineFlyoutVisible: isInlineFlyoutVisible,
    displayFlyoutHeader: displayFlyoutHeader,
    onCancel: onCancel,
    navigateToLensEditor: navigateToLensEditor,
    onApply: onApply,
    isSaveable: isSaveable,
    isScrollable: true,
    language: textBasedMode ? (0, _esQuery.getLanguageDisplayName)('esql') : '',
    isNewPanel: isNewPanel,
    isReadOnly: isReadOnly,
    applyButtonLabel: applyButtonLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            block-size: 100%;
            .euiFlexItem,
            .euiAccordion,
            .euiAccordion__triggerWrapper,
            .euiAccordion__childWrapper {
              min-block-size: 0;
            }
            .euiAccordion {
              display: flex;
              flex: 1;
              flex-direction: column;
            }
            .euiAccordion-isOpen {
              .euiAccordion__childWrapper {
                // Override euiAccordion__childWrapper blockSize only when ES|QL mode is enabled
                block-size: auto ${textBasedMode ? '!important' : ''};
                flex: 1;
              }
            }
            .euiAccordion__childWrapper {
              ${(0, _eui.euiScrollBarStyles)(euiTheme)}
              overflow-y: auto !important;
              pointer-events: none;

              padding-left: ${euiTheme.euiTheme.components.forms.maxWidth};
              margin-left: -${euiTheme.euiTheme.components.forms.maxWidth};
              > * {
                pointer-events: auto;
              }
            }
            .lnsIndexPatternDimensionEditor-advancedOptions {
              .euiAccordion__childWrapper {
                flex: none;
                overflow: hidden !important;
              }
            }
          `,
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
                > * {
                  flex-grow: 0;
                }
              `,
    gutterSize: "none",
    direction: "column",
    ref: editorContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isLayerAccordionOpen ? 1 : false,
    css: (0, _react2.css)`
              .euiAccordion__childWrapper {
                flex: ${isLayerAccordionOpen ? 1 : 'none'};
              }
              padding: 0 ${euiTheme.euiTheme.size.base};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "layer-configuration",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react2.css)`
                    padding: 2px;
                  `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 411,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.lens.config.visualizationConfigurationLabel', {
      defaultMessage: 'Visualization parameters'
    }))),
    buttonProps: {
      paddingSize: 'm'
    },
    initialIsOpen: isLayerAccordionOpen,
    forceState: isLayerAccordionOpen ? 'open' : 'closed',
    onToggle: status => {
      if (status && isSuggestionsAccordionOpen) {
        setIsSuggestionsAccordionOpen(!status);
      }
      if (status && isESQLResultsAccordionOpen) {
        setIsESQLResultsAccordionOpen(!status);
      }
      setIsLayerAccordionOpen(!isLayerAccordionOpen);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layer_configuration_section.LayerConfiguration, {
    attributes: attributes,
    dataLoading$: dataLoading$,
    lensAdapters: lensAdapters,
    getUserMessages: getUserMessages,
    coreStart: coreStart,
    startDependencies: startDependencies,
    visualizationMap: visualizationMap,
    datasourceMap: datasourceMap,
    datasourceId: datasourceId,
    framePublicAPI: framePublicAPI,
    setIsInlineFlyoutVisible: setIsInlineFlyoutVisible,
    updateSuggestion: updateSuggestion,
    setCurrentAttributes: setCurrentAttributes,
    closeFlyout: closeFlyout,
    parentApi: parentApi,
    panelId: panelId,
    canEditTextBasedQuery: canEditTextBasedQuery,
    editorContainer: editorContainer.current || undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isSuggestionsAccordionOpen ? 1 : false,
    "data-test-subj": "InlineEditingSuggestions",
    css: (0, _react2.css)`
              border-top: ${euiTheme.euiTheme.border.thin};
              border-bottom: ${euiTheme.euiTheme.border.thin};
              padding-left: ${euiTheme.euiTheme.size.base};
              padding-right: ${euiTheme.euiTheme.size.base};
              .euiAccordion__childWrapper {
                flex: ${isSuggestionsAccordionOpen ? 1 : 'none'};
              }
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestion_panel.SuggestionPanel, {
    ExpressionRenderer: startDependencies.expressions.ReactExpressionRenderer,
    datasourceMap: datasourceMap,
    visualizationMap: visualizationMap,
    frame: framePublicAPI,
    core: coreStart,
    nowProvider: startDependencies.data.nowProvider,
    showOnlyIcons: true,
    wrapSuggestions: true,
    isAccordionOpen: isSuggestionsAccordionOpen,
    toggleAccordionCb: status => {
      if (!status && isLayerAccordionOpen) {
        setIsLayerAccordionOpen(status);
      }
      if (status && isESQLResultsAccordionOpen) {
        setIsESQLResultsAccordionOpen(!status);
      }
      setIsSuggestionsAccordionOpen(!isSuggestionsAccordionOpen);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 13
    }
  })))));
}