"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarItems = exports.Toolbar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _inventory_meta_api = require("../../../../../../common/http_api/inventory_meta_api");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _metrics_source = require("../../../../../containers/metrics_source");
var _aws_ec2_toolbar_items = require("./aws_ec2_toolbar_items");
var _aws_rds_toolbar_items = require("./aws_rds_toolbar_items");
var _aws_s3_toolbar_items = require("./aws_s3_toolbar_items");
var _aws_sqs_toolbar_items = require("./aws_sqs_toolbar_items");
var _container_toolbar_items = require("./container_toolbar_items");
var _host_toolbar_items = require("./host_toolbar_items");
var _pod_toolbar_items = require("./pod_toolbar_items");
var _toolbar_wrapper = require("./toolbar_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/toolbars/toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Toolbar = ({
  nodeType,
  currentTime
}) => {
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    data
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/infra/inventory/meta', {
      method: 'POST',
      body: JSON.stringify({
        sourceId,
        nodeType,
        currentTime
      })
    });
    return (0, _ioTsUtils.decodeOrThrow)(_inventory_meta_api.InventoryMetaResponseRT)(response);
  }, [sourceId, nodeType, currentTime]);
  const {
    accounts = [],
    regions = []
  } = data || {};
  return /*#__PURE__*/_react.default.createElement(_toolbar_wrapper.ToolbarWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ToolbarItems, (0, _extends2.default)({}, props, {
    accounts: accounts,
    regions: regions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })));
};
exports.Toolbar = Toolbar;
const ToolbarItems = props => {
  switch (props.nodeType) {
    case 'awsEC2':
      return /*#__PURE__*/_react.default.createElement(_aws_ec2_toolbar_items.AwsEC2ToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 14
        }
      }));
    case 'awsRDS':
      return /*#__PURE__*/_react.default.createElement(_aws_rds_toolbar_items.AwsRDSToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 14
        }
      }));
    case 'awsS3':
      return /*#__PURE__*/_react.default.createElement(_aws_s3_toolbar_items.AwsS3ToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 14
        }
      }));
    case 'awsSQS':
      return /*#__PURE__*/_react.default.createElement(_aws_sqs_toolbar_items.AwsSQSToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 14
        }
      }));
    case 'container':
      return /*#__PURE__*/_react.default.createElement(_container_toolbar_items.ContainerToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 14
        }
      }));
    case 'host':
      return /*#__PURE__*/_react.default.createElement(_host_toolbar_items.HostToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 14
        }
      }));
    case 'pod':
      return /*#__PURE__*/_react.default.createElement(_pod_toolbar_items.PodToolbarItems, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 14
        }
      }));
  }
};
exports.ToolbarItems = ToolbarItems;