"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_lazy_ref = require("../../../../../hooks/use_lazy_ref");
var _metrics_grid = require("./metrics/metrics_grid");
var _alerts = require("./alerts");
var _alerts_tab_badge = require("./alerts_tab_badge");
var _use_tab_id = require("../../hooks/use_tab_id");
var _logs = require("./logs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tabs = [{
  id: _use_tab_id.TabIds.METRICS,
  name: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.title', {
    defaultMessage: 'Metrics'
  }),
  'data-test-subj': 'hostsView-tabs-metrics'
}, {
  id: _use_tab_id.TabIds.LOGS,
  name: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.logs.title', {
    defaultMessage: 'Logs'
  }),
  'data-test-subj': 'hostsView-tabs-logs'
}, {
  id: _use_tab_id.TabIds.ALERTS,
  name: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.title', {
    defaultMessage: 'Alerts'
  }),
  append: /*#__PURE__*/_react.default.createElement(_alerts_tab_badge.AlertsTabBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  }),
  'data-test-subj': 'hostsView-tabs-alerts'
}];
const Tabs = () => {
  const [selectedTabId, setSelectedTabId] = (0, _use_tab_id.useTabId)(tabs[0].id);
  // This map allow to keep track of which tabs content have been rendered the first time.
  // We need it in order to load a tab content only if it gets clicked, and then keep it in the DOM for performance improvement.
  const renderedTabsSet = (0, _use_lazy_ref.useLazyRef)(() => new Set([selectedTabId]));
  const tabEntries = tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, tab, {
    key: index,
    onClick: () => {
      renderedTabsSet.current.add(tab.id); // On a tab click, mark the tab content as allowed to be rendered
      setSelectedTabId(tab.id);
    },
    isSelected: tab.id === selectedTabId,
    append: tab.append,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }), tab.name));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, tabEntries), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }), renderedTabsSet.current.has(_use_tab_id.TabIds.METRICS) && /*#__PURE__*/_react.default.createElement("div", {
    hidden: selectedTabId !== _use_tab_id.TabIds.METRICS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics_grid.MetricsGrid, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })), renderedTabsSet.current.has(_use_tab_id.TabIds.LOGS) && /*#__PURE__*/_react.default.createElement("div", {
    hidden: selectedTabId !== _use_tab_id.TabIds.LOGS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_logs.LogsTabContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  })), renderedTabsSet.current.has(_use_tab_id.TabIds.ALERTS) && /*#__PURE__*/_react.default.createElement("div", {
    hidden: selectedTabId !== _use_tab_id.TabIds.ALERTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts.AlertsTabContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })));
};
exports.Tabs = Tabs;