"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/datasets_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasetsList = ({
  datasets
}) => /*#__PURE__*/_react.default.createElement("ul", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 16,
    columnNumber: 3
  }
}, datasets.map(dataset => {
  const datasetLabel = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset.name);
  return /*#__PURE__*/_react.default.createElement("li", {
    key: datasetLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(DatasetLabel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 11
    }
  }, datasetLabel));
}));

/*
 * These aim at aligning the list with the EuiHealth list in the neighboring
 * column.
 */
exports.DatasetsList = DatasetsList;
const DatasetLabel = _styled.default.div`
  display: inline-block;
  margin-bottom: 2.5px;
  margin-top: 1px;
`;