"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryExampleMessageTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _rison = require("@kbn/rison");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _log_analysis = require("../../../../../../common/log_analysis");
var _view_log_in_context = require("../../../../../containers/logs/view_log_in_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/category_example_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MENU_LABEL = _i18n.i18n.translate('xpack.infra.logs.categoryExample.menuLabel', {
  defaultMessage: 'View actions for log entry'
});
const CategoryExampleMessageRow = ({
  id,
  dataset,
  message,
  timestamp,
  timeRange,
  tiebreaker,
  context,
  euiTheme
}) => {
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_logs'
  });
  const [, {
    setContextEntry
  }] = (0, _view_log_in_context.useViewLogInProviderContext)();
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const humanFriendlyDataset = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset);
  const time = (0, _moment.default)(timestamp).toISOString();
  const viewInStreamLinkProps = (0, _public.useLinkProps)({
    app: 'logs',
    pathname: 'stream',
    search: {
      logPosition: (0, _rison.encode)({
        end: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        position: {
          tiebreaker,
          time
        },
        start: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        streamLive: false
      }),
      flyoutOptions: (0, _rison.encode)({
        surroundingLogsId: id
      }),
      logFilter: (0, _rison.encode)({
        expression: `${_log_analysis.partitionField}: ${dataset}`,
        kind: 'kuery'
      })
    }
  });
  const toggleMenu = (0, _react.useCallback)(() => setIsMenuOpen(!isMenuOpen), [isMenuOpen]);
  const closeMenu = (0, _react.useCallback)(() => setIsMenuOpen(false), []);
  const handleViewInContext = (0, _react.useCallback)(() => {
    const logEntry = {
      id,
      index: '',
      // TODO: use real index when loading via async search
      context,
      cursor: {
        time: (0, _moment.default)(timestamp).toISOString(),
        tiebreaker
      },
      columns: []
    };
    trackMetric({
      metric: 'view_in_context__categories'
    });
    setContextEntry(logEntry);
    closeMenu();
  }, [closeMenu, context, id, setContextEntry, tiebreaker, timestamp, trackMetric]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "332px",
    css: {
      color: euiTheme.colors.textSubdued
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, (0, _moment.default)(timestamp).format('MMM D, YYYY @ HH:mm:ss.SSS')), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "auto",
    css: {
      overflow: 'hidden',
      textOverflow: 'ellipsis'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, message), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "400px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, humanFriendlyDataset), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "32px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "infraCategoryExampleMessageRowButton",
      "aria-label": MENU_LABEL,
      iconType: "boxesHorizontal",
      size: "s",
      onClick: toggleMenu,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }),
    isOpen: isMenuOpen,
    closePopover: closeMenu,
    panelPaddingSize: "none",
    anchorPosition: "leftCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "viewInDiscover",
      onClick: viewInStreamLinkProps.onClick,
      href: viewInStreamLinkProps.href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.infra.logs.categoryExample.viewInDiscoverText', {
      defaultMessage: 'View in Discover'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "viewInContext",
      onClick: handleViewInContext,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.infra.logs.categoryExample.viewInContextText', {
      defaultMessage: 'View in context'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }))));
};
const CategoryExampleMessageTable = ({
  examples,
  timeRange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    css: {
      tableLayout: 'fixed',
      backgroundColor: euiTheme.colors.borderBaseFloating,
      '& .euiTableRowCell': {
        borderColor: euiTheme.colors.borderBaseFloating,
        padding: '0px 8px',
        fontFamily: euiTheme.font.familyCode
      },
      '& .euiTableCellContent': {
        padding: 0,
        height: '24px'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, examples.map((example, index) => /*#__PURE__*/_react.default.createElement(CategoryExampleMessageRow, (0, _extends2.default)({
    key: index
  }, example, {
    timeRange: timeRange,
    euiTheme: euiTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })))));
};
exports.CategoryExampleMessageTable = CategoryExampleMessageTable;