"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _states = require("./states");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/processes/state_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StateBadge = ({
  state
}) => {
  switch (state) {
    case 'running':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "success",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 15,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.running);
    case 'sleeping':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 17,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.sleeping);
    case 'dead':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 19,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.dead);
    case 'stopped':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 21,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.stopped);
    case 'idle':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "primary",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.idle);
    case 'zombie':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.zombie);
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 14
        }
      }, _states.STATE_NAMES.unknown);
  }
};
exports.StateBadge = StateBadge;