"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _add_metadata_filter_button = require("./add_metadata_filter_button");
var _expandable_content = require("../../components/expandable_content");
var _utils = require("./utils");
var _add_pin_to_row = require("./add_pin_to_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/metadata/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Columns translations
 */
const FIELD_LABEL = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.field', {
  defaultMessage: 'Field'
});
const VALUE_LABEL = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.value', {
  defaultMessage: 'Value'
});

/**
 * Component translations
 */
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.searchForMetadata', {
  defaultMessage: 'Search for metadata…'
});
const NO_METADATA_FOUND = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.noMetadataFound', {
  defaultMessage: 'No metadata found.'
});
const LOADING = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.loading', {
  defaultMessage: 'Loading...'
});
const LOCAL_STORAGE_PINNED_METADATA_ROWS = 'hostsView:pinnedMetadataRows';
const Table = ({
  loading,
  rows,
  onSearchChange,
  search,
  showActionsColumn
}) => {
  const [searchError, setSearchError] = (0, _react.useState)(null);
  const [metadataSearch, setMetadataSearch] = (0, _react.useState)(search);
  const [fieldsWithPins, setFieldsWithPins] = (0, _react.useState)(rows);
  const [pinnedItems, setPinnedItems] = (0, _useLocalStorage.default)(LOCAL_STORAGE_PINNED_METADATA_ROWS, []);
  (0, _react.useMemo)(() => {
    if (pinnedItems) {
      var _getRowsWithPins;
      setFieldsWithPins((_getRowsWithPins = (0, _utils.getRowsWithPins)(rows, pinnedItems)) !== null && _getRowsWithPins !== void 0 ? _getRowsWithPins : rows);
    }
  }, [rows, pinnedItems]);
  const defaultColumns = (0, _react.useMemo)(() => [{
    field: 'value',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pin",
      "aria-label": _i18n.i18n.translate('xpack.infra.metadataEmbeddable.pinFieldsColumn.ariaLabel', {
        defaultMessage: 'Pin fields'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }),
    align: 'center',
    width: '5%',
    sortable: false,
    render: (_name, item) => {
      return /*#__PURE__*/_react.default.createElement(_add_pin_to_row.AddMetadataPinToRow, {
        fieldName: item.name,
        pinnedItems: pinnedItems !== null && pinnedItems !== void 0 ? pinnedItems : [],
        onPinned: setPinnedItems,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      });
    }
  }, {
    field: 'name',
    name: FIELD_LABEL,
    width: '35%',
    sortable: false,
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 35
      }
    }, name)
  }, {
    field: 'value',
    name: VALUE_LABEL,
    width: '50%',
    sortable: false,
    render: (_name, item) => /*#__PURE__*/_react.default.createElement(_expandable_content.ExpandableContent, {
      fieldName: item.name,
      values: item.value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    })
  }], [pinnedItems, setPinnedItems]);
  const debouncedSearchOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(queryText => {
    if (onSearchChange) {
      onSearchChange(queryText);
    }
    setMetadataSearch(queryText);
  }, 500), [onSearchChange]);
  const searchBarOnChange = (0, _react.useCallback)(({
    queryText,
    error
  }) => {
    if (error) {
      setSearchError(error);
    } else {
      setSearchError(null);
      debouncedSearchOnChange(queryText);
    }
  }, [debouncedSearchOnChange]);
  const searchBar = {
    onChange: searchBarOnChange,
    box: {
      'data-test-subj': 'infraAssetDetailsMetadataSearchBarInput',
      incremental: true,
      schema: true,
      placeholder: SEARCH_PLACEHOLDER
    },
    query: metadataSearch ? _eui.Query.parse(metadataSearch) : _eui.Query.MATCH_ALL
  };
  const columns = (0, _react.useMemo)(() => showActionsColumn ? [...defaultColumns, {
    field: 'value',
    name: 'Actions',
    sortable: false,
    align: 'center',
    render: (_name, item) => {
      return /*#__PURE__*/_react.default.createElement(_add_metadata_filter_button.AddMetadataFilterButton, {
        item: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 24
        }
      });
    }
  }] : defaultColumns, [defaultColumns, showActionsColumn]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "infraAssetDetailsMetadataTable",
    tableLayout: "fixed",
    responsiveBreakpoint: false,
    columns: columns,
    items: fieldsWithPins,
    search: searchBar,
    loading: loading,
    error: searchError ? `${searchError.message}` : '',
    message: loading ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "infraAssetDetailsMetadataLoading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }, LOADING) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "infraAssetDetailsMetadataNoData",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 11
      }
    }, NO_METADATA_FOUND),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  });
};
exports.Table = Table;