"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKubernetesCharts = exports.useHostKpiCharts = exports.useHostCharts = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_chart_series_color = require("./use_chart_series_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostCharts = ({
  metric,
  indexPattern,
  overview,
  schema
}) => {
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const hostCharts = await getHostsCharts({
      metric,
      overview,
      schema: schema !== null && schema !== void 0 ? schema : 'ecs'
    });
    return hostCharts.map(chart => ({
      ...chart,
      ...(indexPattern && {
        dataset: {
          index: indexPattern
        }
      })
    }));
  }, [indexPattern, metric, overview, schema]);
  return {
    charts,
    error
  };
};
exports.useHostCharts = useHostCharts;
const useKubernetesCharts = ({
  indexPattern,
  overview
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const {
      kubernetesNode
    } = await model.metrics.getCharts();
    if (!kubernetesNode) {
      return [];
    }
    const items = overview ? [kubernetesNode.xy.nodeCpuCapacity, kubernetesNode.xy.nodeMemoryCapacity] : [kubernetesNode.xy.nodeCpuCapacity, kubernetesNode.xy.nodeMemoryCapacity, kubernetesNode.xy.nodeDiskCapacity, kubernetesNode.xy.nodePodCapacity];
    return items.map(chart => {
      return {
        ...chart,
        ...(indexPattern && {
          dataset: {
            index: indexPattern
          }
        })
      };
    });
  }, [model.metrics, overview, indexPattern]);
  return {
    charts,
    error
  };
};
exports.useKubernetesCharts = useKubernetesCharts;
const getSubtitleFromFormula = value => value.startsWith('max') ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max', {
  defaultMessage: 'Max'
}) : _i18n.i18n.translate('xpack.infra.assetDetails.kpi.subtitle.average', {
  defaultMessage: 'Average'
});
const useHostKpiCharts = ({
  indexPattern,
  seriesColor,
  getSubtitle,
  schema
}) => {
  seriesColor = (0, _use_chart_series_color.useChartSeriesColor)(seriesColor);
  const {
    value: charts = []
  } = (0, _useAsync.default)(async () => {
    const model = (0, _common.findInventoryModel)('host');
    const {
      cpu,
      memory,
      disk
    } = await model.metrics.getCharts({
      schema: schema !== null && schema !== void 0 ? schema : 'ecs'
    });
    return [cpu.metric.cpuUsage, cpu.metric.normalizedLoad1m, memory.metric.memoryUsage, disk.metric.diskUsage].map(chart => ({
      ...chart,
      seriesColor,
      decimals: 1,
      subtitle: getSubtitle ? getSubtitle(chart.value) : getSubtitleFromFormula(chart.value),
      ...(indexPattern && {
        dataset: {
          index: indexPattern
        }
      })
    }));
  }, [indexPattern, seriesColor, getSubtitle, schema]);
  return charts;
};
exports.useHostKpiCharts = useHostKpiCharts;
const getHostsCharts = async ({
  metric,
  overview,
  schema
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    cpu,
    memory,
    network,
    disk,
    logs
  } = await model.metrics.getCharts({
    schema: schema !== null && schema !== void 0 ? schema : 'ecs'
  });
  switch (metric) {
    case 'cpu':
      return overview ? [cpu.xy.cpuUsage, cpu.xy.normalizedLoad1m] : [cpu.xy.cpuUsage, cpu.xy.cpuUsageBreakdown, cpu.xy.normalizedLoad1m, cpu.xy.loadBreakdown];
    case 'memory':
      return overview ? [memory.xy.memoryUsage] : [memory.xy.memoryUsage, memory.xy.memoryUsageBreakdown];
    case 'network':
      return [network.xy.rxTx];
    case 'disk':
      return overview ? [disk.xy.diskUsageByMountPoint, disk.xy.diskIOReadWrite] : [disk.xy.diskUsageByMountPoint, disk.xy.diskIOReadWrite, disk.xy.diskThroughputReadWrite];
    case 'log':
      return [logs.xy.logRate];
    default:
      return [];
  }
};