"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextWindowSize = exports.contextWindowFromModelName = void 0;
var _known_models = require("./known_models");
var _connector_config = require("./connector_config");
var _const = require("../const");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve the context window size for the default model of the given connector, if available.
 */
const getContextWindowSize = connector => {
  var _connector$config;
  if (!connector.config) {
    return undefined;
  }
  if ((_connector$config = connector.config) !== null && _connector$config !== void 0 && _connector$config.contextWindowLength) {
    return connector.config.contextWindowLength;
  }
  const defaultModel = (0, _connector_config.getConnectorDefaultModel)(connector);
  if (defaultModel) {
    return contextWindowFromModelName(defaultModel);
  }
  return undefined;
};
exports.getContextWindowSize = getContextWindowSize;
const contextWindowFromModelName = modelName => {
  if (_const.elasticModelDictionary[modelName]) {
    modelName = _const.elasticModelDictionary[modelName].model;
  }
  const modelDefinition = (0, _known_models.getModelDefinition)(modelName);
  return modelDefinition === null || modelDefinition === void 0 ? void 0 : modelDefinition.contextWindow;
};
exports.contextWindowFromModelName = contextWindowFromModelName;