"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mappings_state_context = require("../../mappings_state_context");
var _shared_imports = require("../../shared_imports");
var _config_context = require("../../config_context");
var _empty_prompt = require("./empty_prompt");
var _runtimefields_list_item_container = require("./runtimefields_list_item_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/runtime_fields/runtime_fields_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const RuntimeFieldsList = () => {
  const runtimeFieldsDocsUri = _shared_imports.documentationService.getRuntimeFields();
  const {
    runtimeFields,
    runtimeFieldsList: {
      status,
      fieldToEdit
    },
    fields
  } = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const {
    value: {
      docLinks
    }
  } = (0, _config_context.useConfig)();
  const createField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'runtimeFieldsList.createField'
    });
  }, [dispatch]);
  const exitEdit = (0, _react.useCallback)(() => {
    dispatch({
      type: 'runtimeFieldsList.closeRuntimeFieldEditor'
    });
  }, [dispatch]);
  const saveRuntimeField = (0, _react.useCallback)(field => {
    if (fieldToEdit) {
      dispatch({
        type: 'runtimeField.edit',
        value: {
          id: fieldToEdit,
          source: field
        }
      });
    } else {
      dispatch({
        type: 'runtimeField.add',
        value: field
      });
    }
  }, [dispatch, fieldToEdit]);
  (0, _react.useEffect)(() => {
    if (status === 'creatingField' || status === 'editingField') {
      var _runtimeFields$fieldT;
      addContentToGlobalFlyout({
        id: 'runtimeFieldEditor',
        Component: _shared_imports.RuntimeFieldEditorFlyoutContent,
        props: {
          onSave: saveRuntimeField,
          onCancel: exitEdit,
          defaultValue: fieldToEdit ? (_runtimeFields$fieldT = runtimeFields[fieldToEdit]) === null || _runtimeFields$fieldT === void 0 ? void 0 : _runtimeFields$fieldT.source : undefined,
          docLinks: docLinks,
          ctx: {
            namesNotAllowed: Object.values(runtimeFields).map(field => field.source.name),
            existingConcreteFields: Object.values(fields.byId).map(field => ({
              name: field.source.name,
              type: field.source.type
            }))
          }
        },
        flyoutProps: {
          'data-test-subj': 'runtimeFieldEditor',
          'aria-labelledby': 'runtimeFieldEditorEditTitle',
          maxWidth: 720,
          onClose: exitEdit
        },
        cleanUpFunc: exitEdit
      });
    } else if (status === 'idle') {
      removeContentFromGlobalFlyout('runtimeFieldEditor');
    }
  }, [status, fieldToEdit, runtimeFields, fields, docLinks, addContentToGlobalFlyout, removeContentFromGlobalFlyout, saveRuntimeField, exitEdit]);
  const fieldsToArray = Object.entries(runtimeFields);
  const isEmpty = fieldsToArray.length === 0;
  const isCreateFieldDisabled = status !== 'idle';
  return isEmpty ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    createField: createField,
    runtimeFieldsDocsUri: runtimeFieldsDocsUri,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.runtimeFieldsDescription",
    defaultMessage: "Define the runtime fields accessible at search time. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: runtimeFieldsDocsUri,
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFieldsDocumentationLink', {
        defaultMessage: 'Learn more.'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, fieldsToArray.map(([fieldId]) => /*#__PURE__*/_react.default.createElement(_runtimefields_list_item_container.RuntimeFieldsListItemContainer, {
    key: fieldId,
    fieldId: fieldId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: isCreateFieldDisabled,
    onClick: createField,
    iconType: "plusInCircleFilled",
    "data-test-subj": "createRuntimeFieldButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addRuntimeFieldButtonLabel', {
    defaultMessage: 'Add field'
  })));
};
exports.RuntimeFieldsList = RuntimeFieldsList;