"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherTypeNameParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/other_type_name_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This is a special component that does not have an explicit entry in {@link PARAMETERS_DEFINITION}.
 *
 * We use it to store the name of types unknown to the mappings editor in the "subType" path.
 */

const typeParameterConfig = (0, _lib.getFieldConfig)('type');
const fieldConfig = {
  label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.otherTypeNameFieldLabel', {
    defaultMessage: 'Type Name'
  }),
  defaultValue: '',
  deserializer: typeParameterConfig.deserializer,
  serializer: typeParameterConfig.serializer,
  validations: [{
    validator: ({
      value: fieldValue
    }) => {
      if (fieldValue[0].value.trim() === '') {
        return {
          message: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.validations.otherTypeNameIsRequiredErrorMessage', {
            defaultMessage: 'The type name is required.'
          })
        };
      }
    }
  }]
};
/**
 * The "subType" parameter can be configured either with a ComboBox (when the type is known)
 * or with a TextField (when the type is unknown). This causes its value to have different type
 * (either an array of object either a string). In order to align both value and let the consumer of
 * the value worry about a single type, we will create a custom TextField component that works with the
 * array of object that the ComboBox works with.
 */
const CustomTextField = ({
  field
}) => {
  var _field$value$0$value, _field$value$;
  const {
    setValue
  } = field;
  const transformedField = {
    ...field,
    value: (_field$value$0$value = (_field$value$ = field.value[0]) === null || _field$value$ === void 0 ? void 0 : _field$value$.value) !== null && _field$value$0$value !== void 0 ? _field$value$0$value : ''
  };
  const onChange = (0, _react.useCallback)(e => {
    setValue([{
      value: e.target.value
    }]);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.TextField, {
    field: transformedField,
    euiFieldProps: {
      onChange,
      'data-test-subj': 'fieldSubType'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
const OtherTypeNameParameter = () => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "subType",
  config: fieldConfig,
  component: CustomTextField,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 3
  }
});
exports.OtherTypeNameParameter = OtherTypeNameParameter;