"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _form = require("../../form");
var _infinity_icon = require("../infinity_icon/infinity_icon.svg");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phase_footer/phase_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const deleteDataLabel = _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseTiming.beforeDeleteDescription', {
  defaultMessage: 'Delete data after this phase'
});
const keepDataLabel = _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseTiming.foreverTimingDescription', {
  defaultMessage: 'Keep data in this phase forever'
});
const PhaseFooter = ({
  phase
}) => {
  const {
    isDeletePhaseEnabled,
    setDeletePhaseEnabled: setValue,
    [phase]: phaseConfiguration
  } = (0, _form.usePhaseTimings)();
  if (!phaseConfiguration.isFinalDataPhase) {
    return null;
  }
  const selectedButton = isDeletePhaseEnabled ? 'ilmEnableDeletePhaseButton' : 'ilmDisableDeletePhaseButton';
  const buttons = [{
    id: `ilmDisableDeletePhaseButton`,
    label: keepDataLabel,
    iconType: _infinity_icon.InfinityIconSvg
  }, {
    id: `ilmEnableDeletePhaseButton`,
    label: deleteDataLabel,
    iconType: 'trash',
    'data-test-subj': 'enableDeletePhaseButton'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, isDeletePhaseEnabled ? deleteDataLabel : keepDataLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.buttonGroupLegend', {
      defaultMessage: 'Enable or disable delete phase'
    }),
    options: buttons,
    idSelected: selectedButton,
    onChange: id => {
      setValue(id === 'ilmEnableDeletePhaseButton');
    },
    isIconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })));
};
exports.PhaseFooter = PhaseFooter;