"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18nProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactIntl = require("react-intl");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-i18n-react/src/provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * The library uses the provider pattern to scope an i18n context to a tree
 * of components. This component is used to setup the i18n context for a tree.
 * IntlProvider should wrap react app's root component (inside each react render method).
 */
const I18nProvider = ({
  children
}) => {
  const isInitialized = _i18n.i18n.getIsInitialized();
  if (!isInitialized) {
    throw new Error('kbn-i18n must be initialized before using <I18nProvider />');
  }
  const {
    messages,
    formats,
    locale,
    defaultLocale,
    defaultFormats
  } = _i18n.i18n.getTranslation();
  return /*#__PURE__*/_react.default.createElement(_reactIntl.IntlProvider, {
    locale: locale,
    messages: messages,
    formats: formats,
    defaultLocale: defaultLocale,
    defaultFormats: defaultFormats,
    onError: _i18n.i18n.handleIntlError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, children);
};
exports.I18nProvider = I18nProvider;