"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphVisualization = GraphVisualization;
var _react = _interopRequireWildcard(require("react"));
var _d = _interopRequireDefault(require("d3"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _persistence = require("../../services/persistence");
var _icon_renderer = require("../icon_renderer");
var _styles = require("../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/graph_visualization/graph_visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function registerZooming(element) {
  const blockScroll = function () {
    _d.default.event.preventDefault();
  };
  _d.default.select(element).on('mousewheel', blockScroll).on('DOMMouseScroll', blockScroll).call(_d.default.behavior.zoom().on('zoom', () => {
    const event = _d.default.event;
    _d.default.select(element).select('g').attr('transform', 'translate(' + event.translate + ')' + 'scale(' + event.scale + ')').attr('style', 'stroke-width: ' + 1 / event.scale);
  }));
}
function makeEdgeId(edge) {
  return `${(0, _persistence.makeNodeId)(edge.source.data.field, edge.source.data.term)}-${(0, _persistence.makeNodeId)(edge.target.data.field, edge.target.data.term)}`;
}
function GraphVisualization({
  workspace,
  selectSelected,
  onSetControl,
  onSetMergeCandidates
}) {
  const svgRoot = (0, _react.useRef)(null);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const nodeClick = (n, event) => {
    // Selection logic - shift key+click helps selects multiple nodes
    // Without the shift key we deselect all prior selections (perhaps not
    // a great idea for touch devices with no concept of shift key)
    if (!event.shiftKey) {
      const prevSelection = n.isSelected;
      workspace.selectNone();
      n.isSelected = prevSelection;
    }
    if (workspace.toggleNodeSelection(n)) {
      selectSelected(n);
    } else {
      onSetControl('none');
    }
    workspace.changeHandler();
  };
  const handleMergeCandidatesCallback = termIntersects => {
    const mergeCandidates = [...termIntersects];
    onSetMergeCandidates(mergeCandidates);
    onSetControl('mergeTerms');
  };
  const edgeClick = edge => {
    // no multiple selection for now
    const currentSelection = workspace.getEdgeSelection();
    if (currentSelection.length && currentSelection[0] !== edge) {
      workspace.clearEdgeSelection();
    }
    if (!edge.isSelected) {
      workspace.addEdgeToSelection(edge);
    } else {
      workspace.removeEdgeFromSelection(edge);
    }
    onSetControl('edgeSelection');
    if (edge.isSelected) {
      workspace.getAllIntersections(handleMergeCandidatesCallback, [edge.topSrc, edge.topTarget]);
    }
  };
  return /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    className: "gphGraph",
    css: styles.graph,
    width: "100%",
    height: "100%",
    pointerEvents: "all",
    id: "graphSvg",
    ref: element => {
      if (element && svgRoot.current !== element) {
        svgRoot.current = element;
        registerZooming(element);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, workspace.edges && workspace.edges.map(edge => /*#__PURE__*/_react.default.createElement("g", {
    key: makeEdgeId(edge),
    css: styles.edgeWrapper,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("line", {
    x1: edge.topSrc.kx,
    y1: edge.topSrc.ky,
    x2: edge.topTarget.kx,
    y2: edge.topTarget.ky,
    className: "gphEdge",
    strokeLinecap: "round",
    style: {
      strokeWidth: edge.width
    },
    css: [styles.edge(euiThemeContext),
    // the stroke and stroke-opacity are overridden
    edge.isSelected && (0, _react2.css)`
                        stroke: ${euiThemeContext.euiTheme.colors.darkShade};
                        stroke-opacity: 0.95;
                      `],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("line", {
    x1: edge.topSrc.kx,
    y1: edge.topSrc.ky,
    x2: edge.topTarget.kx,
    y2: edge.topTarget.ky,
    onClick: () => {
      edgeClick(edge);
    },
    className: "gphEdge gphEdge--clickable",
    style: {
      strokeWidth: Math.max(edge.width, 15)
    },
    css: [styles.edge(euiThemeContext),
    // fill is overridden
    styles.edgeClickable],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  })))), workspace.nodes && workspace.nodes.filter(node => !node.parent).map(node => {
    const iconOffset = (0, _icon_renderer.getIconOffset)(node.icon);
    const kx = node.kx || 0;
    const ky = node.ky || 0;
    return /*#__PURE__*/_react.default.createElement("g", {
      key: (0, _persistence.makeNodeId)(node.data.field, node.data.term),
      onClick: e => {
        nodeClick(node, e);
      },
      onMouseDown: e => {
        // avoid selecting text when selecting nodes
        if (e.ctrlKey || e.shiftKey) {
          e.preventDefault();
        }
      },
      className: "gphNode",
      css: (0, _react2.css)`
                    cursor: pointer;
                  `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("circle", {
      cx: kx,
      cy: ky,
      r: node.scaledSize,
      css: [(0, _react2.css)`
                        fill: ${node.color};
                      `, node.isSelected && (0, _react2.css)`
                          stroke-width: ${euiThemeContext.euiTheme.size.xs};
                          stroke: ${euiThemeContext.euiTheme.colors.borderBasePrimary};
                          paint-order: stroke;
                        `],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
      icon: node.icon,
      color: node.color,
      x: kx - ((iconOffset === null || iconOffset === void 0 ? void 0 : iconOffset.x) || 0),
      y: ky - ((iconOffset === null || iconOffset === void 0 ? void 0 : iconOffset.y) || 0),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 19
      }
    }), node.label.length < 30 && /*#__PURE__*/_react.default.createElement("text", {
      className: "gphNode__label",
      css: [svgTextStyles, (0, _react2.css)`
                          cursor: pointer;
                        `],
      textAnchor: "middle",
      transform: "translate(0,22)",
      x: kx,
      y: ky,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 21
      }
    }, node.label), node.label.length >= 30 && /*#__PURE__*/_react.default.createElement("foreignObject", {
      width: "100",
      height: "20",
      transform: "translate(-50,15)",
      x: kx,
      y: ky,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      className: "gphNode__label",
      css: [svgTextStyles, (0, _react2.css)`
                            cursor: pointer;
                            ${(0, _eui.euiTextTruncate)()};
                            text-align: center;
                          `, _styles.noUserSelectStyles],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 23
      }
    }, node.label)), node.numChildren > 0 && /*#__PURE__*/_react.default.createElement("g", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("circle", {
      r: "5",
      css: styles.nodeMarkerCircle,
      transform: "translate(10,10)",
      cx: kx,
      cy: ky,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement("text", {
      css: [svgTextStyles, (0, _react2.css)`
                            font-size: calc(${euiThemeContext.euiTheme.size.s} - 2px);
                            fill: ${euiThemeContext.euiTheme.colors.emptyShade};
                          `],
      textAnchor: "middle",
      transform: "translate(10,12)",
      x: kx,
      y: ky,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 23
      }
    }, node.numChildren)));
  })));
}
const svgTextStyles = ({
  euiTheme
}) => (0, _react2.css)({
  fontFamily: euiTheme.font.family,
  fontSize: euiTheme.size.s,
  lineHeight: euiTheme.size.m,
  fill: euiTheme.colors.darkShade,
  color: euiTheme.colors.darkShade
});
const styles = {
  graph: (0, _react2.css)({
    flex: 1,
    overflow: 'hidden'
  }),
  edgeWrapper: (0, _react2.css)({
    '&:hover': {
      '.gphEdge': {
        strokeOpacity: 0.95,
        cursor: 'pointer'
      }
    }
  }),
  edge: ({
    euiTheme
  }) => (0, _react2.css)({
    fill: euiTheme.colors.mediumShade,
    stroke: euiTheme.colors.mediumShade,
    strokeOpacity: 0.5,
    fontSize: `calc(${euiTheme.size.s} - 2px)`
  }),
  edgeClickable: (0, _react2.css)({
    fill: 'transparent',
    opacity: 0
  }),
  nodeMarkerCircle: ({
    euiTheme
  }) => (0, _react2.css)({
    fill: euiTheme.colors.darkShade,
    stroke: euiTheme.colors.emptyShade
  })
};