"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _state_management = require("../state_management");
var _graph_client_workspace = require("../services/workspace/graph_client_workspace");
var _workspace_layout = require("../components/workspace_layout");
var _use_workspace_loader = require("../helpers/use_workspace_loader");
var _use_graph_loader = require("../helpers/use_graph_loader");
var _index_pattern_cache = require("../services/index_pattern_cache");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/apps/workspace_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkspaceRoute = ({
  deps: {
    toastNotifications,
    coreStart,
    contentClient,
    graphSavePolicy,
    canEditDrillDownUrls,
    overlays,
    navigation,
    capabilities,
    storage,
    data,
    unifiedSearch,
    getBasePath,
    addBasePath,
    setHeaderActionMenu,
    spaces,
    indexPatterns: getIndexPatternProvider,
    inspect,
    savedObjectsManagement,
    contentManagement
  }
}) => {
  /**
   * It's temporary workaround, which should be removed after migration `workspace` to redux.
   * Ref holds mutable `workspace` object. After each `workspace.methodName(...)` call
   * (which might mutate `workspace` somehow), react state needs to be updated using
   * `workspace.changeHandler()`.
   */
  const workspaceRef = (0, _react.useRef)();
  /**
   * Providing `workspaceRef.current` to the hook dependencies or components itself
   * will not leads to updates, therefore `renderCounter` is used to update react state.
   */
  const [renderCounter, setRenderCounter] = (0, _react.useState)(0);
  const history = (0, _reactRouterDom.useHistory)();
  const indexPatternProvider = (0, _react.useMemo)(() => (0, _index_pattern_cache.createCachedIndexPatternProvider)(getIndexPatternProvider.get), [getIndexPatternProvider.get]);
  const services = (0, _react.useMemo)(() => ({
    appName: 'graph',
    storage,
    data,
    unifiedSearch,
    savedObjectsManagement,
    contentManagement,
    ...coreStart
  }), [coreStart, data, storage, unifiedSearch, savedObjectsManagement, contentManagement]);
  const {
    loading,
    requestAdapter,
    callNodeProxy,
    callSearchNodeProxy,
    handleSearchQueryError
  } = (0, _use_graph_loader.useGraphLoader)({
    toastNotifications,
    coreStart
  });
  const [store] = (0, _react.useState)(() => (0, _state_management.createGraphStore)({
    basePath: getBasePath(),
    addBasePath,
    indexPatternProvider,
    createWorkspace: (indexPattern, exploreControls) => {
      const options = {
        indexName: indexPattern,
        vertex_fields: [],
        // Here we have the opportunity to look up labels for nodes...
        nodeLabeller() {
          // console.log(newNodes);
        },
        changeHandler: () => setRenderCounter(cur => cur + 1),
        graphExploreProxy: callNodeProxy,
        searchProxy: callSearchNodeProxy,
        exploreControls
      };
      const createdWorkspace = workspaceRef.current = (0, _graph_client_workspace.createWorkspace)(options);
      return createdWorkspace;
    },
    getWorkspace: () => workspaceRef.current,
    savePolicy: graphSavePolicy,
    contentClient,
    changeUrl: newUrl => history.push(newUrl),
    notifyReact: () => setRenderCounter(cur => cur + 1),
    handleSearchQueryError,
    ...coreStart
  }));
  const loaded = (0, _use_workspace_loader.useWorkspaceLoader)({
    workspaceRef,
    store,
    contentClient,
    spaces,
    coreStart,
    data
  });
  if (!loaded) {
    return null;
  }
  const {
    savedWorkspace,
    sharingSavedObjectProps
  } = loaded;
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_workspace_layout.WorkspaceLayout, {
    spaces: spaces,
    sharingSavedObjectProps: sharingSavedObjectProps,
    renderCounter: renderCounter,
    workspace: workspaceRef.current,
    loading: loading,
    setHeaderActionMenu: setHeaderActionMenu,
    graphSavePolicy: graphSavePolicy,
    navigation: navigation,
    capabilities: capabilities,
    coreStart: coreStart,
    canEditDrillDownUrls: canEditDrillDownUrls,
    overlays: overlays,
    savedWorkspace: savedWorkspace,
    indexPatternProvider: indexPatternProvider,
    inspect: inspect,
    requestAdapter: requestAdapter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  })));
};
exports.WorkspaceRoute = WorkspaceRoute;