"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAutoUpgradeAgentsStatus = getAutoUpgradeAgentsStatus;
var _common = require("../../../common");
var _services = require("../../../common/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAutoUpgradeAgentsStatus(agentClient, agentPolicyId) {
  const currentVersionsMap = {};
  let total = 0;
  await agentClient.listAgents({
    showInactive: false,
    perPage: 0,
    kuery: `${_services.AgentStatusKueryHelper.buildKueryForActiveAgents()} AND ${_common.AGENTS_PREFIX}.policy_id:"${agentPolicyId}"`,
    aggregations: {
      versions: {
        terms: {
          field: 'agent.version',
          size: 1000
        }
      }
    }
  }).then(result => {
    var _result$aggregations, _result$aggregations$;
    (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : (_result$aggregations$ = _result$aggregations.versions) === null || _result$aggregations$ === void 0 ? void 0 : _result$aggregations$.buckets.forEach(bucket => currentVersionsMap[bucket.key] = {
      version: bucket.key,
      agents: bucket.doc_count,
      failedUpgradeAgents: 0
    });
    total = result.total;
  });
  await agentClient.listAgents({
    showInactive: false,
    perPage: 0,
    kuery: `${_services.AgentStatusKueryHelper.buildKueryForActiveAgents()} AND ${_common.AGENTS_PREFIX}.policy_id:"${agentPolicyId}" AND ${_common.AGENTS_PREFIX}.upgrade_details.state:"UPG_FAILED"`,
    aggregations: {
      versions: {
        terms: {
          field: 'upgrade_details.target_version.keyword',
          size: 1000
        }
      }
    }
  }).then(result => {
    var _result$aggregations2, _result$aggregations3;
    (_result$aggregations2 = result.aggregations) === null || _result$aggregations2 === void 0 ? void 0 : (_result$aggregations3 = _result$aggregations2.versions) === null || _result$aggregations3 === void 0 ? void 0 : _result$aggregations3.buckets.forEach(bucket => {
      var _currentVersionsMap$b, _currentVersionsMap$b2;
      return currentVersionsMap[bucket.key] = {
        version: bucket.key,
        agents: (_currentVersionsMap$b = (_currentVersionsMap$b2 = currentVersionsMap[bucket.key]) === null || _currentVersionsMap$b2 === void 0 ? void 0 : _currentVersionsMap$b2.agents) !== null && _currentVersionsMap$b !== void 0 ? _currentVersionsMap$b : 0,
        failedUpgradeAgents: bucket.doc_count
      };
    });
  });
  return {
    currentVersions: Object.values(currentVersionsMap),
    totalAgents: total
  };
}