"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormElasticsearchSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../services");
var _multi_row_input = require("../multi_row_input");
var _hooks = require("../../../../hooks");
var _ssl_form_section = require("./ssl_form_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_form_elasticsearch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OutputFormElasticsearchSection = props => {
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage
  } = props;
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  const [isConvertedToSecret, setIsConvertedToSecret] = _react.default.useState({
    sslKey: false
  });
  const {
    enableSSLSecrets
  } = _services.ExperimentalFeaturesService.get();
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the output with secret storage
    if (useSecretsStorage && enableSSLSecrets) {
      if (inputs.sslKeyInput.value && !inputs.sslKeySecretInput.value) {
        inputs.sslKeySecretInput.setValue(inputs.sslKeyInput.value);
        inputs.sslKeyInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          sslKey: true
        });
      }
    }
  }, [useSecretsStorage, inputs.sslKeyInput, inputs.sslKeySecretInput, isFirstLoad, setIsFirstLoad, isConvertedToSecret, enableSSLSecrets]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.sslKeyInput.clear();
    } else {
      inputs.sslKeySecretInput.setValue('');
    }
    setIsConvertedToSecret({
      sslKey: false
    });
    onToggleSecretStorage(secretEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.hostUrlInput",
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.esHostsInputLabel', {
      defaultMessage: 'Hosts'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.esHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    })
  }, inputs.elasticsearchUrlInput.props, {
    isUrl: true,
    helpText: (cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serverlessHostUrlsHelpText",
      defaultMessage: "Custom host URLs are not allowed in serverless.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputLabel",
      defaultMessage: "Elasticsearch CA trusted fingerprint (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    })
  }, inputs.caTrustedFingerprintInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true
  }, inputs.caTrustedFingerprintInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputPlaceholder', {
      defaultMessage: 'Specify Elasticsearch CA trusted fingerprint'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ssl_form_section.SSLFormSection, {
    type: inputs.typeInput.value,
    inputs: inputs,
    useSecretsStorage: enableSSLSecrets && useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslKey,
    onToggleSecretAndClearValue: onToggleSecretAndClearValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }));
};
exports.OutputFormElasticsearchSection = OutputFormElasticsearchSection;