"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _components = require("../../components");
var _hooks = require("../../hooks");
var _layouts = require("../../layouts");
var _agent_list_page = require("./agent_list_page");
var _agent_requirements_page = require("./agent_requirements_page");
var _agent_details_page = require("./agent_details_page");
var _no_access = require("./error_pages/no_access");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentsApp = () => {
  var _fleetStatus$missingR;
  (0, _hooks.useBreadcrumbs)('agent_list');
  const {
    agents
  } = (0, _hooks.useConfig)();
  const authz = (0, _hooks.useAuthz)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const flyoutContext = (0, _hooks.useFlyoutContext)();
  if (!agents.enabled) return null;
  if (!fleetStatus.missingRequirements && fleetStatus.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  if (fleetStatus.error) {
    return /*#__PURE__*/_react.default.createElement(_layouts.WithoutHeaderLayout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentsInitializationErrorMessageTitle",
        defaultMessage: "Unable to initialize central management for Elastic Agents",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      }),
      error: fleetStatus.error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }));
  }
  const hasOnlyFleetServerMissingRequirement = (fleetStatus === null || fleetStatus === void 0 ? void 0 : (_fleetStatus$missingR = fleetStatus.missingRequirements) === null || _fleetStatus$missingR === void 0 ? void 0 : _fleetStatus$missingR.length) === 1 && fleetStatus.missingRequirements[0] === 'fleet_server';
  const displayInstructions = authz.fleet.allAgents && (fleetStatus.forceDisplayInstructions || hasOnlyFleetServerMissingRequirement);
  if (!hasOnlyFleetServerMissingRequirement && fleetStatus.missingRequirements && fleetStatus.missingRequirements.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_agent_requirements_page.MissingESRequirementsPage, {
      missingRequirements: fleetStatus.missingRequirements,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    });
  }
  if (!authz.fleet.readAgents) {
    return /*#__PURE__*/_react.default.createElement(_no_access.NoAccessPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 12
      }
    });
  }
  const rightColumn = displayInstructions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: () => flyoutContext.openEnrollmentFlyout(),
    "data-test-subj": "addAgentBtnTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addAgentButton",
    defaultMessage: "Add Agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }))))) : undefined;
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_details_page.AgentDetailsPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "agents",
    rightColumn: rightColumn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, displayInstructions ? /*#__PURE__*/_react.default.createElement(_agent_requirements_page.FleetServerRequirementPage, {
    showEnrollmentRecommendation: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_agent_list_page.AgentListPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }))));
};
exports.AgentsApp = AgentsApp;