"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentReassignAgentPolicyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _constants = require("../../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/agent_reassign_policy_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentReassignAgentPolicyModal = ({
  onClose,
  agents
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const isSingleAgent = Array.isArray(agents) && agents.length === 1;
  const agentPoliciesRequest = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const agentPolicies = (0, _react.useMemo)(() => agentPoliciesRequest.data ? agentPoliciesRequest.data.items.filter(policy => policy && !policy.is_managed) : [], [agentPoliciesRequest.data]);
  const [selectedAgentPolicyId, setSelectedAgentPolicyId] = (0, _react.useState)(isSingleAgent ? agents[0].policy_id : undefined);

  // Select the first policy if not policy is selected
  (0, _react.useEffect)(() => {
    if (!selectedAgentPolicyId && agentPolicies.length) {
      var _agentPolicies$;
      setSelectedAgentPolicyId((_agentPolicies$ = agentPolicies[0]) === null || _agentPolicies$ === void 0 ? void 0 : _agentPolicies$.id);
    }
  }, [selectedAgentPolicyId, agentPolicies]);
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  async function onSubmit() {
    try {
      setIsSubmitting(true);
      if (!selectedAgentPolicyId) {
        throw new Error('No selected agent policy id');
      }
      const res = isSingleAgent ? await (0, _hooks.sendPostAgentReassign)(agents[0].id, {
        policy_id: selectedAgentPolicyId
      }) : await (0, _hooks.sendPostBulkAgentReassign)({
        policy_id: selectedAgentPolicyId,
        agents: Array.isArray(agents) ? agents.map(agent => agent.id) : agents,
        includeInactive: true
      });
      if (res.error) {
        throw res.error;
      }
      setIsSubmitting(false);
      const successMessage = _i18n.i18n.translate('xpack.fleet.agentReassignPolicy.successSingleNotificationTitle', {
        defaultMessage: 'Reassigning agent policy'
      });
      notifications.toasts.addSuccess(successMessage);
      onClose();
    } catch (error) {
      setIsSubmitting(false);
      notifications.toasts.addError(error, {
        title: 'Unable to reassign agent policy'
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "agentReassignPolicyModal",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentReassignPolicy.flyoutTitle",
      defaultMessage: "Assign new agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }),
    onCancel: onClose,
    onConfirm: onSubmit,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentReassignPolicy.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }),
    confirmButtonDisabled: isSubmitting || isSingleAgent && selectedAgentPolicyId === agents[0].policy_id,
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentReassignPolicy.continueButtonLabel",
      defaultMessage: "Assign policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }),
    buttonColor: "primary",
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentReassignPolicy.flyoutDescription",
    defaultMessage: "Choose a new agent policy to assign the selected {count, plural, one {agent} other {agents}} to.",
    values: {
      count: isSingleAgent ? 1 : 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.fleet.agentReassignPolicy.selectPolicyLabel', {
      defaultMessage: 'Agent policy'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    isLoading: agentPoliciesRequest.isLoading,
    options: agentPolicies.map(agentPolicy => ({
      value: agentPolicy.id,
      text: agentPolicy.name
    })),
    value: selectedAgentPolicyId,
    onChange: e => setSelectedAgentPolicyId(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, selectedAgentPolicyId && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyPackageBadges, {
    agentPolicyId: selectedAgentPolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }))));
};
exports.AgentReassignAgentPolicyModal = AgentReassignAgentPolicyModal;