"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevelFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_logs/filter_log_level.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogLevelFilter = exports.LogLevelFilter = /*#__PURE__*/(0, _react.memo)(({
  selectedLevels,
  onToggleLevel
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(prevIsOpen => !prevIsOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const [options, setOptions] = (0, _react.useState)(_constants.AGENT_LOG_LEVELS.map(level => ({
    label: level,
    checked: selectedLevels.includes(level) ? 'on' : undefined,
    key: level
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "agentList.logLevelFilterBtn",
      iconType: "arrowDown",
      onClick: togglePopover,
      isSelected: isOpen,
      numFilters: options.length,
      hasActiveFilters: selectedLevels.length > 0,
      numActiveFilters: selectedLevels.length,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fleet.agentLogs.logLevelSelectText', {
      defaultMessage: 'Log level'
    })),
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: newOptions => {
      setOptions(newOptions);
      newOptions.forEach((option, index) => {
        if (option.checked !== options[index].checked) {
          onToggleLevel(option.label);
          return;
        }
      });
    },
    "data-test-subj": "agentList.logLevelFilterOptions",
    listProps: {
      paddingSize: 's'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, list => list));
});