"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegendAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _legend_action_popover = require("./legend_action_popover");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/legend_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getLegendAction = (dataLayers, onFilter, layerCellValueActions, fieldFormats, formattedDatatables, titles, singleTable) => /*#__PURE__*/_react.default.memo(({
  series: [xySeries]
}) => {
  var _layerCellValueAction, _layerCellValueAction2, _getSeriesName;
  const series = xySeries;
  const layerIndex = dataLayers.findIndex(l => series.seriesKeys.some(key => l.accessors.some(accessor => (0, _utils.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
  const allYAccessors = dataLayers.flatMap(dataLayer => dataLayer.accessors);
  if (layerIndex === -1) {
    return null;
  }
  const layer = dataLayers[layerIndex];
  if (!layer || !layer.splitAccessors || !layer.splitAccessors.length) {
    return null;
  }
  const {
    table
  } = layer;
  const filterActionData = [];
  const cellValueActionData = [];
  series.splitAccessors.forEach((value, accessor) => {
    const rowIndex = formattedDatatables[layer.layerId].table.rows.findIndex(row => {
      return row[accessor] === value;
    });
    const columnIndex = table.columns.findIndex(column => column.id === accessor);
    if (rowIndex >= 0 && columnIndex >= 0) {
      filterActionData.push({
        row: rowIndex,
        column: columnIndex,
        value: table.rows[rowIndex][accessor],
        table
      });
      cellValueActionData.push({
        value: table.rows[rowIndex][accessor],
        columnMeta: table.columns[columnIndex].meta
      });
    }
  });
  if (filterActionData.length === 0) {
    return null;
  }
  const filterHandler = ({
    negate
  } = {}) => {
    onFilter({
      data: filterActionData,
      negate
    });
  };
  const legendCellValueActions = (_layerCellValueAction = (_layerCellValueAction2 = layerCellValueActions[layerIndex]) === null || _layerCellValueAction2 === void 0 ? void 0 : _layerCellValueAction2.map(action => ({
    ...action,
    execute: () => action.execute(cellValueActionData)
  }))) !== null && _layerCellValueAction !== void 0 ? _layerCellValueAction : [];
  return /*#__PURE__*/_react.default.createElement(_legend_action_popover.LegendActionPopover, {
    label: ((_getSeriesName = (0, _helpers.getSeriesName)(series, {
      splitAccessors: layer.splitAccessors,
      accessorsCount: singleTable ? allYAccessors.length : layer.accessors.length,
      columns: table.columns,
      splitAccessorsFormats: fieldFormats[layer.layerId].splitSeriesAccessors,
      alreadyFormattedColumns: formattedDatatables[layer.layerId].formattedColumns,
      columnToLabelMap: layer.columnToLabel ? JSON.parse(layer.columnToLabel) : {},
      multipleLayersWithSplits: (0, _helpers.hasMultipleLayersWithSplits)(dataLayers)
    }, titles)) === null || _getSeriesName === void 0 ? void 0 : _getSeriesName.toString()) || '',
    onFilter: filterHandler,
    legendCellValueActions: legendCellValueActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  });
});
exports.getLegendAction = getLegendAction;