"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesChartTypesSelect = SeriesChartTypesSelect;
exports.XYChartTypesSelect = XYChartTypesSelect;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_series_storage = require("../../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/chart_types.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CHART_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.chartTypes.label', {
  defaultMessage: 'Chart type'
});
function SeriesChartTypesSelect({
  seriesId,
  series,
  defaultChartType
}) {
  var _series$seriesType;
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const seriesType = (_series$seriesType = series === null || series === void 0 ? void 0 : series.seriesType) !== null && _series$seriesType !== void 0 ? _series$seriesType : defaultChartType;
  const onChange = value => {
    setSeries(seriesId, {
      ...series,
      seriesType: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(XYChartTypesSelect, {
    onChange: onChange,
    value: seriesType,
    excludeChartTypes: ['bar_percentage_stacked'],
    includeChartTypes: ['bar', 'bar_horizontal', 'line', 'area', 'bar_stacked', 'area_stacked', 'bar_horizontal_percentage_stacked'],
    label: CHART_TYPE_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
}
function XYChartTypesSelect({
  onChange,
  value,
  includeChartTypes,
  excludeChartTypes
}) {
  var _vizTypes;
  const {
    services: {
      lens
    }
  } = (0, _public.useKibana)();
  const {
    data = [],
    loading
  } = (0, _public2.useFetcher)(() => lens.getXyVisTypes(), [lens]);
  let vizTypes = data;
  if ((excludeChartTypes !== null && excludeChartTypes !== void 0 ? excludeChartTypes : []).length > 0) {
    vizTypes = vizTypes.filter(({
      id
    }) => !(excludeChartTypes !== null && excludeChartTypes !== void 0 && excludeChartTypes.includes(id)));
  }
  if ((includeChartTypes !== null && includeChartTypes !== void 0 ? includeChartTypes : []).length > 0) {
    vizTypes = vizTypes.filter(({
      id
    }) => includeChartTypes === null || includeChartTypes === void 0 ? void 0 : includeChartTypes.includes(id));
  }
  const options = ((_vizTypes = vizTypes) !== null && _vizTypes !== void 0 ? _vizTypes : []).map(({
    id,
    fullLabel,
    label,
    icon
  }) => {
    const LabelWithIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, fullLabel || label));
    return {
      value: id,
      inputDisplay: LabelWithIcon,
      dropdownDisplay: LabelWithIcon
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: CHART_TYPE_LABEL,
    style: {
      minWidth: 280
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    valueOfSelected: value,
    isLoading: loading,
    options: options,
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
}