"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAsExpression = void 0;
exports.isAssignment = isAssignment;
exports.isWhereExpression = exports.isUnaryExpression = exports.isTimeDurationLiteral = exports.isStringLiteral = exports.isSource = exports.isQuery = exports.isProperNode = exports.isParametrized = exports.isParamLiteral = exports.isOptionNode = exports.isMap = exports.isLiteral = exports.isList = exports.isIntegerLiteral = exports.isInlineCast = exports.isIdentifier = exports.isFunctionExpression = exports.isFieldExpression = exports.isDoubleLiteral = exports.isDatePeriodLiteral = exports.isCommand = exports.isColumn = exports.isBooleanLiteral = exports.isBinaryExpression = void 0;
var _walker = require("../walker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isProperNode = node => !!node && typeof node === 'object' && !Array.isArray(node) && typeof node.type === 'string' && !!node.type;
exports.isProperNode = isProperNode;
const isQuery = node => isProperNode(node) && node.type === 'query';
exports.isQuery = isQuery;
const isCommand = node => isProperNode(node) && node.type === 'command';
exports.isCommand = isCommand;
const isFunctionExpression = node => isProperNode(node) && node.type === 'function';
exports.isFunctionExpression = isFunctionExpression;
const isUnaryExpression = node => isFunctionExpression(node) && node.subtype === 'unary-expression';

/**
 * Returns true if the given node is a binary expression, i.e. an operator
 * surrounded by two operands:
 *
 * ```
 * 1 + 1
 * column LIKE "foo"
 * foo = "bar"
 * ```
 *
 * @param node Any ES|QL AST node.
 */
exports.isUnaryExpression = isUnaryExpression;
const isBinaryExpression = node => isFunctionExpression(node) && node.subtype === 'binary-expression';
exports.isBinaryExpression = isBinaryExpression;
const isWhereExpression = node => isBinaryExpression(node) && node.name === 'where';
exports.isWhereExpression = isWhereExpression;
const isAsExpression = node => isBinaryExpression(node) && node.name === 'as';
exports.isAsExpression = isAsExpression;
const isFieldExpression = node => isBinaryExpression(node) && node.name === '=';
exports.isFieldExpression = isFieldExpression;
const isLiteral = node => isProperNode(node) && node.type === 'literal';
exports.isLiteral = isLiteral;
const isStringLiteral = node => isLiteral(node) && node.literalType === 'keyword';
exports.isStringLiteral = isStringLiteral;
const isIntegerLiteral = node => isLiteral(node) && node.literalType === 'integer';
exports.isIntegerLiteral = isIntegerLiteral;
const isDoubleLiteral = node => isLiteral(node) && node.literalType === 'double';
exports.isDoubleLiteral = isDoubleLiteral;
const isBooleanLiteral = node => isLiteral(node) && node.literalType === 'boolean';
exports.isBooleanLiteral = isBooleanLiteral;
const isTimeDurationLiteral = node => isLiteral(node) && node.literalType === 'time_duration';
exports.isTimeDurationLiteral = isTimeDurationLiteral;
const isDatePeriodLiteral = node => isLiteral(node) && node.literalType === 'date_period';
exports.isDatePeriodLiteral = isDatePeriodLiteral;
const isParamLiteral = node => isLiteral(node) && node.literalType === 'param';
exports.isParamLiteral = isParamLiteral;
const isColumn = node => isProperNode(node) && node.type === 'column';
exports.isColumn = isColumn;
const isSource = node => isProperNode(node) && node.type === 'source';
exports.isSource = isSource;
const isMap = node => isProperNode(node) && node.type === 'map';
exports.isMap = isMap;
const isIdentifier = node => isProperNode(node) && node.type === 'identifier';
exports.isIdentifier = isIdentifier;
const isList = node => isProperNode(node) && node.type === 'list';
exports.isList = isList;
const isOptionNode = node => {
  return !!node && typeof node === 'object' && !Array.isArray(node) && node.type === 'option';
};
exports.isOptionNode = isOptionNode;
const isInlineCast = node => isProperNode(node) && node.type === 'inlineCast';
exports.isInlineCast = isInlineCast;
function isAssignment(node) {
  return isFunctionExpression(node) && node.name === '=';
}
const isParametrized = node => _walker.Walker.params(node).length > 0;
exports.isParametrized = isParametrized;