"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KQLSyntaxError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const endOfInputText = _i18n.i18n.translate('esQuery.kql.errors.endOfInputText', {
  defaultMessage: 'end of input'
});
const grammarRuleTranslations = {
  fieldName: _i18n.i18n.translate('esQuery.kql.errors.fieldNameText', {
    defaultMessage: 'field name'
  }),
  value: _i18n.i18n.translate('esQuery.kql.errors.valueText', {
    defaultMessage: 'value'
  }),
  literal: _i18n.i18n.translate('esQuery.kql.errors.literalText', {
    defaultMessage: 'literal'
  }),
  whitespace: _i18n.i18n.translate('esQuery.kql.errors.whitespaceText', {
    defaultMessage: 'whitespace'
  })
};
const getItemText = item => {
  if (item.type === 'other') {
    return item.description;
  } else if (item.type === 'literal') {
    return `"${item.text}"`;
  } else if (item.type === 'end') {
    return 'end of input';
  } else {
    return item.text || item.description || '';
  }
};
/**
 * A type of error indicating KQL syntax errors
 * @public
 */
class KQLSyntaxError extends Error {
  constructor(error, expression) {
    let message = error.message;
    if (error.expected) {
      const translatedExpectations = error.expected.map(expected => {
        const key = getItemText(expected);
        return grammarRuleTranslations[key] || key;
      });
      const translatedExpectationText = (0, _lodash.uniq)(translatedExpectations).filter(item => item !== undefined).sort().join(', ');
      message = _i18n.i18n.translate('esQuery.kql.errors.syntaxError', {
        defaultMessage: 'Expected {expectedList} but {foundInput} found.',
        values: {
          expectedList: translatedExpectationText,
          foundInput: error.found ? `"${error.found}"` : endOfInputText
        }
      });
    }
    const fullMessage = [message, expression, (0, _lodash.repeat)('-', error.location.start.offset) + '^'].join('\n');
    super(fullMessage);
    (0, _defineProperty2.default)(this, "shortMessage", void 0);
    this.name = 'KQLSyntaxError';
    this.shortMessage = message;
  }
}
exports.KQLSyntaxError = KQLSyntaxError;