"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelStarted = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../shared/kibana");
var _utils = require("../utils");
var _text_expansion_callout = require("./text_expansion_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/text_expansion_callout/model_started.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ModelStarted = ({
  dismiss,
  isCompact,
  isDismissable,
  isSingleThreaded
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "success",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "s",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "checkInCircleFilled",
  color: "success",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 13
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "success",
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 15
  }
}, isSingleThreaded ? isCompact ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedSingleThreadedTitleCompact', {
  defaultMessage: 'Your ELSER model is running single-threaded.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedSingleThreadedTitle', {
  defaultMessage: 'Your ELSER model has started single-threaded.'
}) : isCompact ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedTitleCompact', {
  defaultMessage: 'Your ELSER model is running.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedTitle', {
  defaultMessage: 'Your ELSER model has started.'
})))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_text_expansion_callout.TextExpansionDismissButton, {
  dismiss: dismiss,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 15
  }
})))), !isCompact && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 15
  }
}, isSingleThreaded ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedSingleThreadedBody', {
  defaultMessage: 'This single-threaded configuration is great for testing your custom inference pipelines, however performance should be fine-tuned for production.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedBody', {
  defaultMessage: 'Enjoy the power of ELSER in your custom Inference pipeline.'
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "m",
  alignItems: "center",
  justifyContent: "flexStart",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 15
  }
}, isSingleThreaded ? /*#__PURE__*/_react.default.createElement(_text_expansion_callout.FineTuneModelsButton, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 19
  }
}) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_utils.TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 109,
    columnNumber: 19
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.viewModelsButton', {
  defaultMessage: 'View details'
}))))))));
exports.ModelStarted = ModelStarted;