"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throwIfPublicApiDisabled = void 0;
var _get_kibana_feature_flags = require("./get_kibana_feature_flags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Throws an error with `statusCode: 403` if the Attack Discovery public API is
 * disabled in Kibana feature flags.
 *
 * @throws {Error} - Throws an error with status code 403 if the feature is disabled
 */
const throwIfPublicApiDisabled = async context => {
  const {
    attackDiscoveryPublicApiEnabled
  } = await (0, _get_kibana_feature_flags.getKibanaFeatureFlags)(context);
  if (!attackDiscoveryPublicApiEnabled) {
    throw Object.assign(new Error('Attack discovery public API is disabled'), {
      statusCode: 403
    });
  }
};
exports.throwIfPublicApiDisabled = throwIfPublicApiDisabled;