"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertScheduleActionsToAlertingActions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isSystemAction = (action, actionsClient) => {
  return actionsClient.isSystemAction(action.id);
};
const convertScheduleActionsToAlertingActions = ({
  actionsClient,
  scheduleActions
}) => {
  return (scheduleActions !== null && scheduleActions !== void 0 ? scheduleActions : []).reduce((acc, value) => {
    if (isSystemAction(value, actionsClient)) {
      acc.systemActions.push(value);
    } else {
      acc.actions.push(value);
    }
    return acc;
  }, {
    actions: [],
    systemActions: []
  });
};
exports.convertScheduleActionsToAlertingActions = convertScheduleActionsToAlertingActions;