"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conversationExists = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if a conversation exists by ID without user access filtering
 */
const conversationExists = async ({
  esClient,
  logger,
  conversationIndex,
  id
}) => {
  try {
    const response = await esClient.search({
      query: {
        bool: {
          must: [{
            term: {
              _id: id
            }
          }]
        }
      },
      _source: false,
      ignore_unavailable: true,
      index: conversationIndex,
      size: 0
    });
    return response.hits.total.value > 0;
  } catch (err) {
    logger.error(`Error checking if conversation exists: ${err} with id: ${id}`);
    return false;
  }
};
exports.conversationExists = conversationExists;