"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStacktraceControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_stack_trace_fields = require("../../utils/get_stack_trace_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-discover-utils/src/components/custom_control_columns/stacktrace_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Stacktrace control factory function.
 * @param props Optional props for the generated Control component, useful to override onClick, etc
 */
const createStacktraceControl = props => ({
  id: 'connectedStacktraceDocs',
  render: (Control, rowProps) => {
    return /*#__PURE__*/_react.default.createElement(Stacktrace, (0, _extends2.default)({
      Control: Control,
      rowProps: rowProps
    }, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 12
      }
    }));
  }
});
exports.createStacktraceControl = createStacktraceControl;
const stacktraceAvailableControlButton = _i18n.i18n.translate('discover.customControl.stacktrace.available', {
  defaultMessage: 'Stacktraces available'
});
const stacktraceNotAvailableControlButton = _i18n.i18n.translate('discover.customControl.stacktrace.notAvailable', {
  defaultMessage: 'Stacktraces not available'
});
const Stacktrace = ({
  Control,
  rowProps: {
    record
  },
  ...props
}) => {
  const stacktrace = (0, _get_stack_trace_fields.getStacktraceFields)(record);
  const hasValue = Object.values(stacktrace).some(Boolean);
  return hasValue ? /*#__PURE__*/_react.default.createElement(Control, (0, _extends2.default)({
    "data-test-subj": "docTableStacktraceExist",
    label: stacktraceAvailableControlButton,
    tooltipContent: stacktraceAvailableControlButton,
    iconType: "apmTrace",
    onClick: undefined
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(Control, (0, _extends2.default)({
    disabled: true,
    "data-test-subj": "docTableStacktraceDoesNotExist",
    label: stacktraceNotAvailableControlButton,
    tooltipContent: stacktraceNotAvailableControlButton,
    iconType: "apmTrace",
    onClick: undefined
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }));
};