"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _api = require("./api");
var _get_max_bytes = require("./application/common/util/get_max_bytes");
var _register_home = require("./register_home");
var _kibana_services = require("./kibana_services");
var _locator = require("./application/index_data_visualizer/locator");
var _field_stats = require("./application/index_data_visualizer/embeddables/field_stats");
var _register_ui_actions = require("./register_ui_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DataVisualizerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "resultsLinks", {
      fileBeat: {
        enabled: true
      }
    });
    const resultsLinks = initializerContext.config.get().resultLinks;
    if (resultsLinks !== undefined) {
      var _resultsLinks$fileBea, _resultsLinks$fileBea2;
      this.resultsLinks.fileBeat.enabled = (_resultsLinks$fileBea = (_resultsLinks$fileBea2 = resultsLinks.fileBeat) === null || _resultsLinks$fileBea2 === void 0 ? void 0 : _resultsLinks$fileBea2.enabled) !== null && _resultsLinks$fileBea !== void 0 ? _resultsLinks$fileBea : true;
    }
  }
  async setup(core, plugins) {
    if (plugins.embeddable) {
      (0, _field_stats.registerEmbeddables)(plugins.embeddable, core);
    }
    if (plugins.home) {
      (0, _register_home.registerHomeAddData)(plugins.home, this.resultsLinks);
      (0, _register_home.registerHomeFeatureCatalogue)(plugins.home);
    }
    plugins.share.url.locators.create(new _locator.IndexDataVisualizerLocatorDefinition());
  }
  start(core, plugins) {
    (0, _kibana_services.setStartServices)(core, plugins);
    if (plugins.uiActions) {
      (0, _register_ui_actions.registerUiActions)(core, plugins);
    }
    const {
      getFileDataVisualizerComponent,
      getIndexDataVisualizerComponent,
      getDataDriftComponent
    } = (0, _api.getComponents)(this.resultsLinks);
    return {
      getFileDataVisualizerComponent,
      getIndexDataVisualizerComponent,
      getDataDriftComponent,
      getMaxBytesFormatted: _get_max_bytes.getMaxBytesFormatted,
      FieldStatsUnavailableMessage: (0, _sharedUxUtility.dynamic)(async () => Promise.resolve().then(() => _interopRequireWildcard(require('./application/index_data_visualizer/embeddables/grid_embeddable/embeddable_error_msg')))),
      FieldStatisticsTable: (0, _sharedUxUtility.dynamic)(async () => Promise.resolve().then(() => _interopRequireWildcard(require('./application/index_data_visualizer/embeddables/grid_embeddable/field_stats_wrapper'))))
    };
  }
}
exports.DataVisualizerPlugin = DataVisualizerPlugin;