"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overrides = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fileUploadCommon = require("@kbn/file-upload-common");
var _options = require("./options");
var _overrides_validation = require("./overrides_validation");
var _public = require("@kbn/kibana-react-plugin/public");
var _grok_pattern = require("../../../../common/util/grok_pattern");
var _overrides_utils = require("./overrides_utils");
var _option_lists = require("./options/option_lists");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/edit_flyout/overrides.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formatOptions = (0, _options.getFormatOptions)();
const timestampFormatOptions = (0, _options.getTimestampFormatOptions)();
const delimiterOptions = (0, _options.getDelimiterOptions)();
const quoteOptions = (0, _options.getQuoteOptions)();
class OverridesUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "linesToSampleErrors", _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.linesToSampleErrorMessage', {
      defaultMessage: 'Value must be greater than {min} and less than or equal to {max}',
      values: {
        min: _overrides_utils.LINES_TO_SAMPLE_VALUE_MIN,
        max: _overrides_utils.LINES_TO_SAMPLE_VALUE_MAX
      }
    }));
    (0, _defineProperty2.default)(this, "customTimestampFormatErrors", _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.customTimestampFormatErrorMessage', {
      defaultMessage: `Timestamp format must be a combination of these Java date/time formats:
      yy, yyyy, M, MM, MMM, MMMM, d, dd, EEE, EEEE, H, HH, h, mm, ss, S through SSSSSSSSS, a, XX, XXX, zzz`
    }));
    (0, _defineProperty2.default)(this, "applyOverrides", () => {
      const overrides = {
        ...this.state.overrides
      };
      overrides.delimiter = (0, _overrides_utils.convertDelimiterBack)(overrides.delimiter, this.state.customDelimiter);
      if (overrides.timestampFormat === _option_lists.CUSTOM_DROPDOWN_OPTION && this.state.customTimestampFormat !== '') {
        overrides.timestampFormat = this.state.customTimestampFormat;
      }
      this.props.setOverrides(overrides);
    });
    (0, _defineProperty2.default)(this, "onFormatChange", ([opt]) => {
      const format = opt ? opt.label : '';
      this.setOverride({
        format
      });
    });
    (0, _defineProperty2.default)(this, "onTimestampFormatChange", ([opt]) => {
      const timestampFormat = opt ? opt.label : '';
      this.setOverride({
        timestampFormat
      });
      if (opt !== _option_lists.CUSTOM_DROPDOWN_OPTION) {
        this.props.setOverridesValid(true);
      }
    });
    (0, _defineProperty2.default)(this, "onCustomTimestampFormatChange", e => {
      this.setState({
        customTimestampFormat: e.target.value
      });
      // check whether the value is valid and set that to state.
      const {
        isValid,
        errorMessage
      } = (0, _overrides_validation.isTimestampFormatValid)(e.target.value);
      this.setState({
        timestampFormatValid: isValid,
        timestampFormatError: errorMessage
      });
      this.props.setOverridesValid(isValid);
    });
    (0, _defineProperty2.default)(this, "onTimestampFieldChange", ([opt]) => {
      const timestampField = opt ? opt.label : '';
      this.setOverride({
        timestampField
      });
    });
    (0, _defineProperty2.default)(this, "onContainsTimeFieldChange", e => {
      this.setState({
        containsTimeField: e.target.checked
      });
      if (e.target.checked === false) {
        this.setOverride({
          timestampFormat: _fileUploadCommon.NO_TIME_FORMAT
        });
      } else {
        this.setOverride({
          timestampFormat: this.props.originalSettings.timestampFormat
        });
      }
    });
    (0, _defineProperty2.default)(this, "onDelimiterChange", ([opt]) => {
      const delimiter = opt ? opt.label : '';
      this.setOverride({
        delimiter
      });
    });
    (0, _defineProperty2.default)(this, "onCustomDelimiterChange", e => {
      this.setState({
        customDelimiter: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onQuoteChange", ([opt]) => {
      const quote = opt ? opt.label : '';
      this.setOverride({
        quote
      });
    });
    (0, _defineProperty2.default)(this, "onHasHeaderRowChange", e => {
      this.setOverride({
        hasHeaderRow: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onShouldTrimFieldsChange", e => {
      this.setOverride({
        shouldTrimFields: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onCharsetChange", ([opt]) => {
      const charset = opt ? opt.label : '';
      this.setOverride({
        charset
      });
    });
    (0, _defineProperty2.default)(this, "onColumnNameChange", (e, i) => {
      const columnNames = this.state.overrides.columnNames;
      columnNames[i] = e.target.value;
      this.setOverride({
        columnNames
      });
    });
    (0, _defineProperty2.default)(this, "onGrokPatternFieldChange", (e, i) => {
      const name = e.target.value;
      const newGrokPattern = (0, _grok_pattern.replaceFieldInGrokPattern)(this.state.overrides.grokPattern, name, i);
      const newGrokFieldNames = (0, _overrides_utils.getGrokFieldNames)(newGrokPattern, this.state.overrides.grokPattern);
      this.setOverride({
        grokPattern: newGrokPattern,
        grokFieldNames: newGrokFieldNames
      });
    });
    (0, _defineProperty2.default)(this, "grokPatternChange", e => {
      const newGrokPattern = e.target.value;
      const newGrokFieldNames = (0, _overrides_utils.getGrokFieldNames)(newGrokPattern, this.state.overrides.grokPattern);
      this.setOverride({
        grokPattern: newGrokPattern,
        grokFieldNames: newGrokFieldNames
      });
    });
    (0, _defineProperty2.default)(this, "onLinesToSampleChange", e => {
      const linesToSample = +e.target.value;
      this.setOverride({
        linesToSample
      });

      // check whether the value is valid and set that to state.
      const linesToSampleValid = (0, _overrides_utils.isLinesToSampleValid)(linesToSample);
      this.setState({
        linesToSampleValid
      });

      // set the overrides valid setting in the parent component,
      // used to disable the Apply button if any of the overrides are invalid
      this.props.setOverridesValid(linesToSampleValid);
    });
    this.state = {};
  }
  static getDerivedStateFromProps(props, state) {
    const {
      originalSettings
    } = props;
    const {
      charset,
      format,
      hasHeaderRow,
      columnNames,
      delimiter,
      quote,
      shouldTrimFields,
      grokPattern,
      timestampField,
      timestampFormat,
      linesToSample
    } = props.overrides;
    const {
      delimiter: d,
      customDelimiter: customD
    } = (0, _overrides_utils.convertDelimiter)(delimiter === undefined ? originalSettings.delimiter : delimiter);
    const {
      newColumnNames,
      originalColumnNames
    } = (0, _overrides_utils.getColumnNames)(columnNames, originalSettings);
    const newGrokFieldNames = (0, _overrides_utils.getGrokFieldNames)(grokPattern, originalSettings.grokPattern);
    const overrides = {
      charset: charset === undefined ? originalSettings.charset : charset,
      format: format === undefined ? originalSettings.format : format,
      hasHeaderRow: hasHeaderRow === undefined ? originalSettings.hasHeaderRow : hasHeaderRow,
      columnNames: newColumnNames,
      grokFieldNames: newGrokFieldNames,
      delimiter: d,
      quote: quote === undefined ? originalSettings.quote : quote,
      shouldTrimFields: shouldTrimFields === undefined ? originalSettings.shouldTrimFields : shouldTrimFields,
      grokPattern: grokPattern === undefined ? originalSettings.grokPattern : grokPattern,
      timestampFormat: timestampFormat === undefined ? originalSettings.timestampFormat : timestampFormat,
      timestampField: timestampField === undefined ? originalSettings.timestampField : timestampField,
      linesToSample: linesToSample === undefined ? originalSettings.linesToSample : +linesToSample
    };
    return {
      originalColumnNames,
      originalGrokFieldNames: newGrokFieldNames,
      customDelimiter: customD === undefined ? '' : customD,
      customTimestampFormat: '',
      linesToSampleValid: true,
      timestampFormatValid: true,
      timestampFormatError: null,
      containsTimeField: overrides.timestampFormat !== _fileUploadCommon.NO_TIME_FORMAT,
      overrides,
      ...state
    };
  }
  componentDidMount() {
    const originalTimestampFormat = this.props && this.props.originalSettings && this.props.originalSettings.timestampFormat;
    if (typeof this.props.setApplyOverrides === 'function') {
      this.props.setApplyOverrides(this.applyOverrides);
    }
    if (originalTimestampFormat !== undefined) {
      const optionExists = _option_lists.TIMESTAMP_OPTIONS.some(option => option === originalTimestampFormat);
      if (optionExists === false) {
        // Incoming format does not exist in dropdown. Display custom input with incoming format as default value.
        const overrides = {
          ...this.state.overrides
        };
        overrides.timestampFormat = _option_lists.CUSTOM_DROPDOWN_OPTION;
        this.setState({
          customTimestampFormat: originalTimestampFormat,
          overrides
        });
      }
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetApplyOverrides === 'function') {
      this.props.unsetApplyOverrides();
    }
  }
  setOverride(o) {
    const overrides = {
      ...this.state.overrides,
      ...o
    };
    this.setState({
      overrides
    });
  }
  render() {
    const {
      fields
    } = this.props;
    const {
      customDelimiter,
      customTimestampFormat,
      originalColumnNames,
      originalGrokFieldNames,
      linesToSampleValid,
      timestampFormatError,
      timestampFormatValid,
      containsTimeField,
      overrides
    } = this.state;
    const {
      timestampFormat,
      timestampField,
      format,
      delimiter,
      quote,
      hasHeaderRow,
      shouldTrimFields,
      // charset,
      columnNames,
      grokFieldNames,
      grokPattern,
      linesToSample
    } = overrides;
    const fieldOptions = getSortedFields(fields);
    const timestampFormatErrorsList = [this.customTimestampFormatErrors, timestampFormatError];
    const docsUrl = this.props.kibana.services.docLinks.links.aggs.date_format_pattern;
    const timestampFormatHelp = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docsUrl,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.timestampFormatHelpText', {
      defaultMessage: 'See more on accepted formats'
    })));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(SectionTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrides.generalSettingsTitle",
      defaultMessage: "General",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      error: this.linesToSampleErrors,
      isInvalid: linesToSampleValid === false,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.linesToSampleFormRowLabel",
        defaultMessage: "Number of lines to sample",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: linesToSample,
      onChange: this.onLinesToSampleChange,
      isInvalid: linesToSampleValid === false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.dataFormatFormRowLabel",
        defaultMessage: "Data format",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 355,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: formatOptions,
      selectedOptions: selectedOption(format),
      onChange: this.onFormatChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 11
      }
    })), format === _fileUploadCommon.FILE_FORMATS.DELIMITED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.delimiterFormRowLabel",
        defaultMessage: "Delimiter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 375,
          columnNumber: 17
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: delimiterOptions,
      selectedOptions: selectedOption(delimiter),
      onChange: this.onDelimiterChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 15
      }
    })), delimiter === _option_lists.CUSTOM_DROPDOWN_OPTION && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.customDelimiterFormRowLabel",
        defaultMessage: "Custom delimiter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: customDelimiter,
      onChange: this.onCustomDelimiterChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 400,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.quoteCharacterFormRowLabel",
        defaultMessage: "Quote character",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 411,
          columnNumber: 17
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: quoteOptions,
      selectedOptions: selectedOption(quote),
      onChange: this.onQuoteChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 417,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: 'hasHeaderRow',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.hasHeaderRowLabel",
        defaultMessage: "Has header row",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 431,
          columnNumber: 19
        }
      }),
      checked: hasHeaderRow,
      onChange: this.onHasHeaderRowChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 442,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: 'shouldTrimFields',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.trimFieldsLabel",
        defaultMessage: "Should trim fields",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 446,
          columnNumber: 19
        }
      }),
      checked: shouldTrimFields,
      onChange: this.onShouldTrimFieldsChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 443,
        columnNumber: 15
      }
    }))), format === _fileUploadCommon.FILE_FORMATS.SEMI_STRUCTURED_TEXT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.grokPatternFormRowLabel",
        defaultMessage: "Grok pattern",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 17
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 460,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      placeholder: grokPattern,
      value: grokPattern,
      onChange: this.grokPatternChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 469,
        columnNumber: 15
      }
    }))), format === _fileUploadCommon.FILE_FORMATS.DELIMITED || format === _fileUploadCommon.FILE_FORMATS.SEMI_STRUCTURED_TEXT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 481,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(SectionTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrides.dateAndTimeTitle",
      defaultMessage: "Date & Time",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 484,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: 'containsTimeField',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.containsTimeFieldLabel",
        defaultMessage: "Contains time field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 494,
          columnNumber: 19
        }
      }),
      checked: containsTimeField,
      onChange: this.onContainsTimeFieldChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 15
      }
    })), containsTimeField ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      helpText: timestampFormatHelp,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.timestampFormatFormRowLabel",
        defaultMessage: "Timestamp format",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 511,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 507,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: timestampFormatOptions,
      selectedOptions: selectedOption(timestampFormat),
      onChange: this.onTimestampFormatChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 517,
        columnNumber: 19
      }
    })), timestampFormat === _option_lists.CUSTOM_DROPDOWN_OPTION && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      error: timestampFormatErrorsList,
      isInvalid: timestampFormatValid === false,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.customTimestampFormatFormRowLabel",
        defaultMessage: "Custom timestamp format",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 532,
          columnNumber: 23
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 527,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: customTimestampFormat,
      onChange: this.onCustomTimestampFormatChange,
      isInvalid: timestampFormatValid === false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 538,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.timeFieldFormRowLabel",
        defaultMessage: "Time field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 549,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 546,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: fieldOptions,
      selectedOptions: selectedOption(timestampField),
      onChange: this.onTimestampFieldChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 555,
        columnNumber: 19
      }
    }))) : null) : null, format === _fileUploadCommon.FILE_FORMATS.DELIMITED && originalColumnNames.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 571,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(SectionTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 573,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrides.editFieldNamesTitle",
      defaultMessage: "Field names",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 574,
        columnNumber: 15
      }
    })), originalColumnNames.map((f, i) => {
      const fieldName = columnNames[i];
      const isTimeField = fieldName === timestampField;
      let value = fieldName;
      if (isTimeField) {
        value = _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.timestampFieldInfo', {
          defaultMessage: 'Timestamp field cannot be renamed'
        });
      } else if (fieldName === f) {
        value = '';
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        key: f,
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 595,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        value: value,
        onChange: e => this.onColumnNameChange(e, i),
        compressed: true,
        disabled: isTimeField,
        prepend: f,
        placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.fieldNamePlaceholder', {
          defaultMessage: 'Change field name'
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 596,
          columnNumber: 19
        }
      }));
    })), format === _fileUploadCommon.FILE_FORMATS.SEMI_STRUCTURED_TEXT && originalGrokFieldNames.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 618,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(SectionTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 620,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrides.editFieldNamesTitle",
      defaultMessage: "Field names",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 621,
        columnNumber: 15
      }
    })), originalGrokFieldNames.map((f, i) => {
      const fieldName = grokFieldNames[i];
      const value = fieldName === f ? '' : fieldName;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        key: f,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 631,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        value: value,
        onChange: e => this.onGrokPatternFieldChange(e, i, grokPattern),
        compressed: true,
        prepend: f,
        placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.fieldNamePlaceholder', {
          defaultMessage: 'Change field name'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 632,
          columnNumber: 19
        }
      }));
    })));
  }
}
function SectionTitle({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 657,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 658,
      columnNumber: 9
    }
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 661,
      columnNumber: 7
    }
  }));
}
const Overrides = exports.Overrides = (0, _public.withKibana)(OverridesUI);
function selectedOption(opt) {
  return [{
    label: opt || ''
  }];
}

// return a list of objects compatible with EuiComboBox
// also sort alphanumerically
function getSortedFields(fields) {
  return fields.map(f => ({
    label: f
  })).sort((a, b) => a.label.localeCompare(b.label, undefined, {
    numeric: true
  }));
}