"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValuesPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _column_chart = require("./column_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_row/top_values_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TopValuesPreview = ({
  config,
  isNumeric
}) => {
  const {
    stats
  } = config;
  if (stats === undefined) return null;
  const {
    topValues,
    cardinality
  } = stats;
  if (cardinality === undefined || topValues === undefined || config.fieldName === undefined) return null;
  const data = topValues.map(d => {
    var _d$key;
    return {
      ...d,
      key: (_d$key = d.key) === null || _d$key === void 0 ? void 0 : _d$key.toString()
    };
  });
  const chartData = {
    cardinality,
    data,
    id: config.fieldName,
    type: 'ordinal'
  };
  const columnType = {
    id: config.fieldName,
    schema: undefined
  };
  return /*#__PURE__*/_react.default.createElement(_column_chart.ColumnChart, {
    chartData: chartData,
    columnType: columnType,
    dataTestSubj: `dataVisualizerDataGridChart-${config.fieldName}`,
    hideLabel: true,
    maxChartColumns: 10,
    isNumeric: isNumeric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
};
exports.TopValuesPreview = TopValuesPreview;