"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _expanded_row_panel = require("./expanded_row_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_expanded_row/date_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TIME_FORMAT = 'MMM D YYYY, HH:mm:ss.SSS';
const DateContent = ({
  config
}) => {
  const {
    stats
  } = config;
  if (stats === undefined) return null;
  const {
    earliest,
    latest
  } = stats;
  const summaryTableTitle = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.cardDate.summaryTableTitle', {
    defaultMessage: 'Summary'
  });
  const summaryTableItems = [{
    function: 'earliest',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.cardDate.earliestLabel",
      defaultMessage: "earliest",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }),
    value: typeof earliest === 'string' ? earliest : (0, _eui.formatDate)(earliest, TIME_FORMAT)
  }, {
    function: 'latest',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.cardDate.latestLabel",
      defaultMessage: "latest",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }),
    value: typeof latest === 'string' ? latest : (0, _eui.formatDate)(latest, TIME_FORMAT)
  }];
  const summaryTableColumns = [{
    name: '',
    field: 'function',
    render: (func, summaryItem) => summaryItem.display,
    width: '70px',
    align: _eui.LEFT_ALIGNMENT
  }, {
    field: 'value',
    name: '',
    render: v => /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 30
      }
    }, v),
    align: _eui.RIGHT_ALIGNMENT
  }];
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerDateContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvSummaryTable__wrapper dvPanel__wrapper dvPanel__dateSummary',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, summaryTableTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: 'dvSummaryTable',
    "data-test-subj": 'dataVisualizerDateSummaryTable',
    compressed: true,
    items: summaryTableItems,
    columns: summaryTableColumns,
    tableCaption: summaryTableTitle,
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })));
};
exports.DateContent = DateContent;