"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardRecentlyAccessedService = void 0;
var _recentlyAccessed = require("@kbn/recently-accessed");
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let dashboardRecentlyAccessed;
const getDashboardRecentlyAccessedService = () => {
  if (!dashboardRecentlyAccessed) {
    dashboardRecentlyAccessed = new _recentlyAccessed.RecentlyAccessedService().start({
      http: _kibana_services.coreServices.http,
      key: 'dashboardRecentlyAccessed'
    });
  }
  return dashboardRecentlyAccessed;
};
exports.getDashboardRecentlyAccessedService = getDashboardRecentlyAccessedService;