"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderNavControls = HeaderNavControls;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _header_extension = require("./header_extension");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_nav_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function HeaderNavControls({
  navControls$,
  append = null
}) {
  const navControls = (0, _useObservable.default)(navControls$, []);
  if (!navControls || navControls.length === 0) {
    return null;
  }

  // It should be performant to use the index as the key since these are unlikely
  // to change while Kibana is running.
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, navControls.map((navControl, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_extension.HeaderExtension, {
    extension: navControl.mount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }))), append);
}