"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllSuggestionsAggregationBuilder = void 0;
var _common = require("@kbn/data-views-plugin/common");
var _lodash = require("lodash");
var _options_list_suggestion_query_helpers = require("./options_list_suggestion_query_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Fetch all suggestions without any additional searching/filtering.
 * This query will be more-or-less the same for **all** field types,
 */
const getAllSuggestionsAggregationBuilder = () => allSuggestionsAggregationBuilder;
exports.getAllSuggestionsAggregationBuilder = getAllSuggestionsAggregationBuilder;
const allSuggestionsAggregationBuilder = {
  buildAggregation: ({
    fieldName,
    fieldSpec,
    sort,
    size,
    allowExpensiveQueries
  }) => {
    let suggestionsAgg = {
      suggestions: {
        terms: {
          size,
          field: fieldName,
          shard_size: 10,
          order: (0, _options_list_suggestion_query_helpers.getSortType)(sort)
        }
      }
    };
    if (allowExpensiveQueries) {
      suggestionsAgg = {
        ...suggestionsAgg,
        unique_terms: {
          cardinality: {
            field: fieldName
          }
        }
      };
    }
    const subTypeNested = fieldSpec && (0, _common.getFieldSubtypeNested)(fieldSpec);
    if (subTypeNested) {
      return {
        nestedSuggestions: {
          nested: {
            path: subTypeNested.nested.path
          },
          aggs: {
            ...suggestionsAgg
          }
        }
      };
    }
    return suggestionsAgg;
  },
  parse: (rawEsResult, {
    fieldSpec,
    allowExpensiveQueries
  }) => {
    var _get;
    const subTypeNested = fieldSpec && (0, _common.getFieldSubtypeNested)(fieldSpec);
    const suggestions = (_get = (0, _lodash.get)(rawEsResult, `aggregations.${subTypeNested ? 'nestedSuggestions.suggestions' : 'suggestions'}.buckets`)) === null || _get === void 0 ? void 0 : _get.reduce((acc, suggestion) => {
      acc.push({
        value: (fieldSpec === null || fieldSpec === void 0 ? void 0 : fieldSpec.type) === 'boolean' && suggestion.key_as_string ? suggestion.key_as_string : suggestion.key,
        docCount: suggestion.doc_count
      });
      return acc;
    }, []);
    return {
      suggestions,
      totalCardinality: allowExpensiveQueries ? (0, _lodash.get)(rawEsResult, `aggregations.${subTypeNested ? 'nestedSuggestions.unique_terms' : 'unique_terms'}.value`) : undefined
    };
  }
};