"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeTemporayStateManager = void 0;
var _state_manager = require("@kbn/presentation-publishing/state_manager");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultTemporaryState = {
  searchString: '',
  searchStringValid: true,
  requestSize: _constants.MIN_OPTIONS_LIST_REQUEST_SIZE,
  dataLoading: false,
  availableOptions: undefined,
  invalidSelections: new Set(),
  totalCardinality: 0
};
const initializeTemporayStateManager = () => {
  return (0, _state_manager.initializeStateManager)(defaultTemporaryState, defaultTemporaryState);
};
exports.initializeTemporayStateManager = initializeTemporayStateManager;