"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemovableUser = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _hoverable_user_with_avatar = require("./hoverable_user_with_avatar");
var _removable_item = require("../removable_item/removable_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_profiles/removable_user.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RemovableUserComponent = ({
  assignee,
  onRemoveAssignee
}) => {
  var _assignee$profile$use, _assignee$profile;
  const removeAssigneeCallback = (0, _react.useCallback)(() => onRemoveAssignee(assignee.uid), [onRemoveAssignee, assignee.uid]);
  const usernameDataTestSubj = (_assignee$profile$use = (_assignee$profile = assignee.profile) === null || _assignee$profile === void 0 ? void 0 : _assignee$profile.user.username) !== null && _assignee$profile$use !== void 0 ? _assignee$profile$use : assignee.uid;
  return /*#__PURE__*/_react.default.createElement(_removable_item.RemovableItem, {
    onRemoveItem: removeAssigneeCallback,
    tooltipContent: i18n.REMOVE_ASSIGNEE,
    buttonAriaLabel: i18n.REMOVE_ASSIGNEE_ARIA_LABEL,
    dataTestSubjPrefix: `user-profile-assigned-user-${usernameDataTestSubj}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar.HoverableUserWithAvatar, {
    userInfo: assignee.profile,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};
RemovableUserComponent.displayName = 'RemovableUser';
const RemovableUser = exports.RemovableUser = /*#__PURE__*/_react.default.memo(RemovableUserComponent);