"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/thehive/case_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const tlpOptions = Object.entries(_types.TheHiveTLP).reduce((acc, [key, value]) => typeof value === 'number' ? [...acc, {
  text: key,
  value
}] : acc, []);
const TheHiveFieldsComponent = () => {
  const form = (0, _hook_form_lib.useFormContext)();
  const onTLPChange = value => {
    form.setFieldValue('fields.tlp', parseInt(value, 10));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'connector-fields-Thehive',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.tlp",
    component: _components.SelectField,
    config: {
      label: i18n.TLP_LABEL,
      validations: [{
        validator: emptyField(i18n.TLP_REQUIRED)
      }],
      defaultValue: _types.TheHiveTLP.AMBER
    },
    onChange: onTLPChange,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'tlp-field',
        options: tlpOptions,
        fullWidth: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
};
exports.default = TheHiveFieldsComponent;
TheHiveFieldsComponent.displayName = 'ThehiveFields';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;