"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumns = exports.ExternalServiceColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _empty_value = require("../empty_value");
var _formatted_date = require("../formatted_date");
var _links = require("../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_actions = require("./use_actions");
var _use_cases_columns_configuration = require("./use_cases_columns_configuration");
var _kibana = require("../../common/lib/kibana");
var _truncated_text = require("../truncated_text");
var _utils = require("../utils");
var _config = require("../severity/config");
var _assignees_column = require("./assignees_column");
var _builder = require("../custom_fields/builder");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var _incremental_id = require("../incremental_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/use_cases_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LINE_CLAMP = 3;
const getLineClampedCss = (0, _react2.css)`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: normal;
`;
const renderStringField = (field, dataTestSubj) => field != null ? /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": dataTestSubj,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 19
  }
}, field) : (0, _empty_value.getEmptyCellValue)();
const useCasesColumns = ({
  userProfiles,
  isSelectorView,
  connectors = [],
  onRowClick,
  disableActions = false,
  selectedColumns,
  disabledCases
}) => {
  const casesColumnsConfig = (0, _use_cases_columns_configuration.useCasesColumnsConfiguration)(isSelectorView);
  const {
    actions
  } = (0, _use_actions.useActions)({
    disableActions
  });
  const {
    data: {
      customFields
    },
    isFetching: isLoadingColumns
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)({
    keepPreviousData: true
  });
  const assignCaseAction = (0, _react.useCallback)(async theCase => {
    if (onRowClick) {
      onRowClick(theCase);
    }
  }, [onRowClick]);
  const columnsDict = (0, _react.useMemo)(() => ({
    title: {
      field: casesColumnsConfig.title.field,
      name: casesColumnsConfig.title.name,
      sortable: true,
      render: (title, theCase) => {
        if (theCase.id != null && theCase.title != null) {
          const caseDetailsLinkComponent = isSelectorView ? theCase.title : /*#__PURE__*/_react.default.createElement("div", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 116,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
            detailName: theCase.id,
            title: theCase.title,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 117,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
            text: theCase.title,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 118,
              columnNumber: 19
            }
          })), typeof theCase.incrementalId === 'number' ? /*#__PURE__*/_react.default.createElement(_incremental_id.IncrementalIdText, {
            incrementalId: theCase.incrementalId,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 121,
              columnNumber: 19
            }
          }) : null);
          return caseDetailsLinkComponent;
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: !isSelectorView ? '17%' : '55%'
    },
    assignees: {
      field: casesColumnsConfig.assignees.field,
      name: casesColumnsConfig.assignees.name,
      render: assignees => /*#__PURE__*/_react.default.createElement(_assignees_column.AssigneesColumn, {
        assignees: assignees,
        userProfiles: userProfiles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 11
        }
      }),
      width: '10%'
    },
    tags: {
      field: casesColumnsConfig.tags.field,
      name: casesColumnsConfig.tags.name,
      render: tags => {
        if (tags != null && tags.length > 0) {
          const clampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
            "data-test-subj": "case-table-column-tags",
            css: getLineClampedCss,
            gutterSize: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 146,
              columnNumber: 15
            }
          }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            css: (0, _react2.css)`
                      max-width: 100px;
                    `,
            color: "hollow",
            key: `${tag}-${i}`,
            "data-test-subj": `case-table-column-tags-${tag}`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 152,
              columnNumber: 19
            }
          }, tag)));
          const unclampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
            "data-test-subj": "case-table-column-tags",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 167,
              columnNumber: 15
            }
          }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow",
            key: `${tag}-${i}`,
            "data-test-subj": `case-table-column-tags-${tag}`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 169,
              columnNumber: 19
            }
          }, tag)));
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            "data-test-subj": "case-table-column-tags-tooltip",
            position: "left",
            content: unclampedBadges,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 181,
              columnNumber: 15
            }
          }, clampedBadges);
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '12%'
    },
    totalAlerts: {
      field: casesColumnsConfig.totalAlerts.field,
      name: casesColumnsConfig.totalAlerts.name,
      align: _eui.RIGHT_ALIGNMENT,
      render: totalAlerts => totalAlerts != null ? renderStringField(`${totalAlerts}`, `case-table-column-alertsCount`) : (0, _empty_value.getEmptyCellValue)(),
      width: !isSelectorView ? '70px' : '55px'
    },
    totalEvents: {
      field: casesColumnsConfig.totalEvents.field,
      name: casesColumnsConfig.totalEvents.name,
      align: _eui.RIGHT_ALIGNMENT,
      render: totalEvents => totalEvents != null ? renderStringField(`${totalEvents}`, `case-table-column-eventsCount`) : (0, _empty_value.getEmptyCellValue)(),
      width: !isSelectorView ? '70px' : '55px'
    },
    totalComment: {
      field: casesColumnsConfig.totalComment.field,
      name: casesColumnsConfig.totalComment.name,
      align: _eui.RIGHT_ALIGNMENT,
      render: totalComment => totalComment != null ? renderStringField(`${totalComment}`, `case-table-column-commentCount`) : (0, _empty_value.getEmptyCellValue)(),
      width: '75px'
    },
    category: {
      field: casesColumnsConfig.category.field,
      name: casesColumnsConfig.category.name,
      sortable: true,
      render: category => {
        if (category != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-category-${category}`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 231,
              columnNumber: 15
            }
          }, category);
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '12%'
    },
    closedAt: {
      field: casesColumnsConfig.closedAt.field,
      name: casesColumnsConfig.closedAt.name,
      sortable: true,
      render: closedAt => {
        if (closedAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-closedAt`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 245,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: closedAt,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 246,
              columnNumber: 17
            }
          }));
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '10%'
    },
    createdAt: {
      field: casesColumnsConfig.createdAt.field,
      name: casesColumnsConfig.createdAt.name,
      sortable: true,
      render: createdAt => {
        if (createdAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-createdAt`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 261,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: createdAt,
            stripMs: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 262,
              columnNumber: 17
            }
          }));
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '15%'
    },
    updatedAt: {
      field: casesColumnsConfig.updatedAt.field,
      name: casesColumnsConfig.updatedAt.name,
      sortable: true,
      render: updatedAt => {
        if (updatedAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": "case-table-column-updatedAt",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 277,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: updatedAt,
            stripMs: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 278,
              columnNumber: 17
            }
          }));
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '15%'
    },
    externalIncident: {
      // no field
      name: casesColumnsConfig.externalIncident.name,
      render: theCase => {
        if (theCase.id != null) {
          return /*#__PURE__*/_react.default.createElement(ExternalServiceColumn, {
            theCase: theCase,
            connectors: connectors,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 291,
              columnNumber: 20
            }
          });
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '10%'
    },
    status: {
      field: casesColumnsConfig.status.field,
      name: casesColumnsConfig.status.name,
      sortable: true,
      render: status => {
        if (status != null) {
          return /*#__PURE__*/_react.default.createElement(_status.Status, {
            status: status,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 303,
              columnNumber: 20
            }
          });
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '100px'
    },
    severity: {
      field: casesColumnsConfig.severity.field,
      name: casesColumnsConfig.severity.name,
      sortable: true,
      render: severity => {
        if (severity != null) {
          return /*#__PURE__*/_react.default.createElement(_config.SeverityHealth, {
            "data-test-subj": `case-table-column-severity-${severity}`,
            severity: severity,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 317,
              columnNumber: 15
            }
          });
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '90px'
    },
    assignCaseAction: {
      // no field
      align: _eui.RIGHT_ALIGNMENT,
      render: theCase => {
        if (theCase.id != null) {
          var _disabledCases$has;
          const disabled = (_disabledCases$has = disabledCases === null || disabledCases === void 0 ? void 0 : disabledCases.has(theCase.id)) !== null && _disabledCases$has !== void 0 ? _disabledCases$has : false;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": `cases-table-row-select-${theCase.id}`,
            onClick: () => assignCaseAction(theCase),
            size: "s",
            iconType: disabled ? 'check' : undefined,
            disabled: disabled,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 334,
              columnNumber: 15
            }
          }, disabled ? i18n.ALREADY_ATTACHED : i18n.SELECT);
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '120px'
    }
  }), [assignCaseAction, casesColumnsConfig, connectors, isSelectorView, userProfiles, disabledCases]);

  // we need to extend the columnsDict with the columns of
  // the customFields
  customFields.forEach(({
    key,
    type,
    label
  }) => {
    if (type in _builder.builderMap) {
      const columnDefinition = _builder.builderMap[type]().getEuiTableColumn({
        label
      });
      columnsDict[key] = {
        ...columnDefinition,
        render: theCase => {
          const customField = theCase.customFields.find(element => element.key === key && element.value !== null);
          if (!customField) {
            return (0, _empty_value.getEmptyCellValue)();
          }
          return columnDefinition.render(customField);
        }
      };
    }
  });
  const columns = [];
  selectedColumns.forEach(({
    field,
    isChecked
  }) => {
    if (field in columnsDict && (isChecked || isSelectorView) && casesColumnsConfig[field].canDisplay) {
      columns.push(columnsDict[field]);
    }
  });
  if (isSelectorView) {
    columns.push(columnsDict.assignCaseAction);
  } else if (actions) {
    columns.push(actions);
  }
  return {
    columns,
    isLoadingColumns,
    rowHeader: casesColumnsConfig.title.field
  };
};
exports.useCasesColumns = useCasesColumns;
const iconWrapperCss = (0, _react2.css)`
  svg {
    height: 20px !important;
    position: relative;
    top: 3px;
    width: 20px !important;
  }
`;
const ExternalServiceColumn = ({
  theCase,
  connectors
}) => {
  var _theCase$externalServ2, _theCase$externalServ3, _theCase$externalServ4, _theCase$externalServ5, _theCase$externalServ6, _theCase$externalServ7, _theCase$externalServ8;
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  if (theCase.externalService == null) {
    return renderStringField(i18n.NOT_PUSHED, `case-table-column-external-notPushed`);
  }
  const lastPushedConnector = connectors.find(connector => {
    var _theCase$externalServ;
    return connector.id === ((_theCase$externalServ = theCase.externalService) === null || _theCase$externalServ === void 0 ? void 0 : _theCase$externalServ.connectorId);
  });
  const lastCaseUpdate = theCase.updatedAt != null ? new Date(theCase.updatedAt) : null;
  const lastCasePush = ((_theCase$externalServ2 = theCase.externalService) === null || _theCase$externalServ2 === void 0 ? void 0 : _theCase$externalServ2.pushedAt) != null ? new Date((_theCase$externalServ3 = theCase.externalService) === null || _theCase$externalServ3 === void 0 ? void 0 : _theCase$externalServ3.pushedAt) : null;
  const hasDataToPush = lastCasePush === null || lastCaseUpdate != null && lastCasePush.getTime() < (lastCaseUpdate === null || lastCaseUpdate === void 0 ? void 0 : lastCaseUpdate.getTime());
  return /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 5
    }
  }, actions.read && /*#__PURE__*/_react.default.createElement("span", {
    css: iconWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "original",
    title: (_theCase$externalServ4 = theCase.externalService) === null || _theCase$externalServ4 === void 0 ? void 0 : _theCase$externalServ4.connectorName,
    type: (0, _utils.getConnectorIcon)(triggersActionsUi, lastPushedConnector === null || lastPushedConnector === void 0 ? void 0 : lastPushedConnector.actionTypeId),
    "data-test-subj": "cases-table-connector-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `case-table-column-external`,
    title: (_theCase$externalServ5 = theCase.externalService) === null || _theCase$externalServ5 === void 0 ? void 0 : _theCase$externalServ5.connectorName,
    href: (_theCase$externalServ6 = theCase.externalService) === null || _theCase$externalServ6 === void 0 ? void 0 : _theCase$externalServ6.externalUrl,
    target: "_blank",
    "aria-label": i18n.PUSH_LINK_ARIA((_theCase$externalServ7 = theCase.externalService) === null || _theCase$externalServ7 === void 0 ? void 0 : _theCase$externalServ7.connectorName),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 7
    }
  }, (_theCase$externalServ8 = theCase.externalService) === null || _theCase$externalServ8 === void 0 ? void 0 : _theCase$externalServ8.externalTitle), hasDataToPush ? renderStringField(i18n.REQUIRES_UPDATE, `case-table-column-external-requiresUpdate`) : renderStringField(i18n.UP_TO_DATE, `case-table-column-external-upToDate`));
};
exports.ExternalServiceColumn = ExternalServiceColumn;
ExternalServiceColumn.displayName = 'ExternalServiceColumn';