"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricRendererFactory = exports.getMetricRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/metric/metric_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getDisplayName: () => _i18n.i18n.translate('xpack.canvas.renderer.metric.displayName', {
    defaultMessage: 'Metric'
  }),
  getHelpDescription: () => _i18n.i18n.translate('xpack.canvas.renderer.metric.helpDescription', {
    defaultMessage: 'Render a number over a label'
  })
};
const getMetricRenderer = core => () => ({
  name: 'metric',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      MetricComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./metric_component')));
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
      analytics: undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(MetricComponent, {
      label: config.label,
      labelFont: config.labelFont ? config.labelFont.spec : {},
      metric: config.metric,
      metricFont: config.metricFont ? config.metricFont.spec : {},
      metricFormat: config.metricFormat,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    })))), domNode, () => handlers.done());
  }
});
exports.getMetricRenderer = getMetricRenderer;
const metricRendererFactory = core => getMetricRenderer(core);
exports.metricRendererFactory = metricRendererFactory;