"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TutorialConfigAgent = TutorialConfigAgent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _agent_config_instructions = require("./agent_config_instructions");
var _get_policy_options = require("./get_policy_options");
var _policy_selector = require("./policy_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/tutorial/config_agent/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CentralizedContainer = _styled.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
`;
const MANAGE_FLEET_POLICIES_LABEL = _i18n.i18n.translate('xpack.apm.tutorial.agent_config.manageFleetPolicies', {
  defaultMessage: 'Manage fleet policies'
});
const GET_STARTED_WITH_FLEET_LABEL = _i18n.i18n.translate('xpack.apm.tutorial.agent_config.getStartedWithFleet', {
  defaultMessage: 'Get started with fleet'
});
const INITIAL_STATE = {
  fleetAgents: [],
  cloudStandaloneSetup: undefined,
  isFleetEnabled: false
};
function getFleetLink({
  isFleetEnabled,
  hasFleetAgents,
  basePath,
  kibanaVersion
}) {
  if (!isFleetEnabled) {
    return;
  }
  return hasFleetAgents ? {
    label: MANAGE_FLEET_POLICIES_LABEL,
    href: `${basePath}/app/fleet#/policies`
  } : {
    label: GET_STARTED_WITH_FLEET_LABEL,
    href: `${basePath}/app/integrations#/detail/apm/overview`
  };
}
function TutorialConfigAgent({
  variantId,
  http,
  basePath,
  isCloudEnabled,
  kibanaVersion
}) {
  const [data, setData] = (0, _react.useState)(INITIAL_STATE);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [selectedOption, setSelectedOption] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function fetchData() {
      setIsLoading(true);
      try {
        const response = await http.get('/internal/apm/fleet/agents');
        if (response) {
          setData(response);
        }
      } catch (e) {
        setIsLoading(false);
        console.error('Error while fetching fleet agents.', e);
      }
    }
    fetchData();
  }, [http]);

  // Depending the environment running (onPrem/Cloud) different values must be available and automatically selected
  const options = (0, _react.useMemo)(() => {
    const availableOptions = (0, _get_policy_options.getPolicyOptions)({
      isCloudEnabled,
      data
    });
    const defaultSelectedOption = availableOptions.find(({
      isSelected
    }) => isSelected);
    setSelectedOption(defaultSelectedOption);
    setIsLoading(false);
    return availableOptions;
  }, [data, isCloudEnabled]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
      "data-test-subj": "loading",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }));
  }
  const hasFleetAgents = !!data.fleetAgents.length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_selector.PolicySelector, {
    options: options,
    selectedOption: selectedOption,
    onChange: newSelectedOption => setSelectedOption(newSelectedOption),
    fleetLink: getFleetLink({
      isFleetEnabled: data.isFleetEnabled,
      hasFleetAgents,
      basePath,
      kibanaVersion
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
    variantId: variantId,
    apmServerUrl: selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.apmServerUrl,
    secretToken: selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.secretToken,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
}